/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.restful.type;

import com.baidu.disconf.core.common.restful.core.UnreliableInterface;
import com.baidu.disconf.core.common.utils.OsUtil;
import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchConfFile
implements UnreliableInterface {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FetchConfFile.class);
    private URL remoteUrl;
    private File localTmpFile;

    public FetchConfFile(URL remoteUrl, File localTmpFile) {
        this.remoteUrl = remoteUrl;
        this.localTmpFile = localTmpFile;
    }

    @Override
    public <T> T call() throws Exception {
        if (this.localTmpFile.exists()) {
            this.localTmpFile.delete();
        }
        LOGGER.debug("start to download. From: " + this.remoteUrl + " , TO: " + this.localTmpFile.getAbsolutePath());
        FileUtils.copyURLToFile((URL)this.remoteUrl, (File)this.localTmpFile);
        if (!OsUtil.isFileExist(this.localTmpFile.getAbsolutePath())) {
            throw new Exception("download is ok, but cannot find downloaded file." + this.localTmpFile);
        }
        LOGGER.debug("download success!  " + this.localTmpFile.getAbsolutePath());
        return null;
    }
}

