/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.zookeeper.inner;

import com.baidu.disconf.core.common.zookeeper.inner.ConnectionWatcher;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilientActiveKeyValueStore
extends ConnectionWatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ResilientActiveKeyValueStore.class);
    private static final Charset CHARSET = Charset.forName("UTF-8");
    public static final int MAX_RETRIES = 3;
    public static final int RETRY_PERIOD_SECONDS = 2;

    public ResilientActiveKeyValueStore(boolean debug) {
        super(debug);
    }

    public void write(String path, String value) throws InterruptedException, KeeperException {
        int retries = 0;
        while (true) {
            try {
                Stat stat = this.zk.exists(path, false);
                if (stat == null) {
                    this.zk.create(path, value.getBytes(CHARSET), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    break;
                }
                this.zk.setData(path, value.getBytes(CHARSET), stat.getVersion());
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (KeeperException e) {
                LOGGER.warn("write connect lost... will retry " + retries + "\t" + e.toString());
                if (retries++ == 3) {
                    throw e;
                }
                int sec = 2 * retries;
                LOGGER.warn("sleep " + sec);
                TimeUnit.SECONDS.sleep(sec);
                continue;
            }
            break;
        }
    }

    public String createEphemeralNode(String path, String value, CreateMode createMode) throws InterruptedException, KeeperException {
        int retries = 0;
        while (true) {
            try {
                Stat stat = this.zk.exists(path, false);
                if (stat == null) {
                    return this.zk.create(path, value.getBytes(CHARSET), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
                }
                if (value != null) {
                    this.zk.setData(path, value.getBytes(CHARSET), stat.getVersion());
                }
                return path;
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (KeeperException e) {
                LOGGER.warn("createEphemeralNode connect lost... will retry " + retries + "\t" + e.toString());
                if (retries++ == 3) {
                    throw e;
                }
                int sec = 2 * retries;
                LOGGER.warn("sleep " + sec);
                TimeUnit.SECONDS.sleep(sec);
                continue;
            }
            break;
        }
    }

    public boolean exists(String path) throws InterruptedException, KeeperException {
        int retries = 0;
        while (true) {
            try {
                Stat stat = this.zk.exists(path, false);
                return stat != null;
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (KeeperException e) {
                LOGGER.warn("exists connect lost... will retry " + retries + "\t" + e.toString());
                if (retries++ == 3) {
                    LOGGER.error("connect final failed");
                    throw e;
                }
                int sec = 2 * retries;
                LOGGER.warn("sleep " + sec);
                TimeUnit.SECONDS.sleep(sec);
                continue;
            }
            break;
        }
    }

    public String read(String path, Watcher watcher, Stat stat) throws InterruptedException, KeeperException {
        byte[] data = this.zk.getData(path, watcher, stat);
        return new String(data, CHARSET);
    }

    public List<String> getRootChildren() {
        ArrayList<String> children = new ArrayList();
        try {
            children = this.zk.getChildren("/", false);
        }
        catch (KeeperException e) {
            LOGGER.error(e.toString());
        }
        catch (InterruptedException e) {
            LOGGER.error(e.toString());
        }
        return children;
    }

    public void deleteNode(String path) {
        try {
            this.zk.delete(path, -1);
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.error("cannot delete path: " + path, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn(e.toString());
        }
        catch (KeeperException e) {
            LOGGER.error("cannot delete path: " + path, (Throwable)e);
        }
    }
}

