/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client;

import com.baidu.disconf.client.DisconfMgr;
import com.baidu.disconf.client.store.aspect.DisconfAspectJ;
import com.baidu.disconf.client.store.inner.DisconfCenterHostFilesStore;
import com.baidu.disconf.client.utils.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;

public class DisconfMgrBean
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered,
ApplicationContextAware {
    public static final String SCAN_SPLIT_TOKEN = ",";
    private ApplicationContext applicationContext;
    private String scanPackage = null;
    @Deprecated
    private Set<String> fileList = new HashSet<String>();

    public void destroy() {
        DisconfMgr.getInstance().close();
    }

    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    public int getOrder() {
        return -2147483647;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DisconfCenterHostFilesStore.getInstance().addJustHostFileSet(this.fileList);
        List<String> scanPackList = StringUtil.parseStringToStringList(this.scanPackage, SCAN_SPLIT_TOKEN);
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(scanPackList);
        scanPackList.clear();
        scanPackList.addAll(hs);
        DisconfMgr.getInstance().setApplicationContext(this.applicationContext);
        DisconfMgr.getInstance().firstScan(scanPackList);
        this.registerAspect(registry);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void registerAspect(BeanDefinitionRegistry registry) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DisconfAspectJ.class);
        beanDefinition.setLazyInit(false);
        beanDefinition.setAbstract(false);
        beanDefinition.setAutowireCandidate(true);
        beanDefinition.setScope("singleton");
        registry.registerBeanDefinition("disconfAspectJ", (BeanDefinition)beanDefinition);
    }

    @Deprecated
    public Set<String> getFileList() {
        return this.fileList;
    }

    @Deprecated
    public void setFileList(Set<String> fileList) {
        this.fileList = fileList;
    }
}

