/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.exception.JobException;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeService;
import com.dangdang.ddframe.job.internal.schedule.JobFacade;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.schedule.SchedulerFacade;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduler {
    private static final Logger log = LoggerFactory.getLogger(JobScheduler.class);
    private static final String SCHEDULER_INSTANCE_NAME_SUFFIX = "Scheduler";
    private static final String CRON_TRIGGER_IDENTITY_SUFFIX = "Trigger";
    private final String jobName;
    private final CoordinatorRegistryCenter regCenter;
    private final SchedulerFacade schedulerFacade;
    private final JobFacade jobFacade;
    private final JobDetail jobDetail;
    private Scheduler scheduler;

    public JobScheduler(CoordinatorRegistryCenter regCenter, JobConfiguration jobConfig, ElasticJobListener ... elasticJobListeners) {
        this.jobName = jobConfig.getJobName();
        this.regCenter = regCenter;
        List<ElasticJobListener> elasticJobListenerList = Arrays.asList(elasticJobListeners);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, jobConfig, elasticJobListenerList);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobConfig, elasticJobListenerList);
        this.jobFacade = new JobFacade(regCenter, jobConfig, elasticJobListenerList);
        this.jobDetail = JobBuilder.newJob(jobConfig.getJobClass()).withIdentity(this.jobName).build();
    }

    private void setGuaranteeServiceForElasticJobListeners(CoordinatorRegistryCenter regCenter, JobConfiguration jobConfig, List<ElasticJobListener> elasticJobListeners) {
        GuaranteeService guaranteeService = new GuaranteeService(regCenter, jobConfig);
        for (ElasticJobListener each : elasticJobListeners) {
            if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
            ((AbstractDistributeOnceElasticJobListener)each).setGuaranteeService(guaranteeService);
        }
    }

    public void init() {
        log.debug("Elastic job: job controller init, job name is: {}.", (Object)this.jobName);
        this.schedulerFacade.clearPreviousServerStatus();
        this.regCenter.addCacheData("/" + this.jobName);
        this.schedulerFacade.registerStartUpInfo();
        this.jobDetail.getJobDataMap().put("jobFacade", (Object)this.jobFacade);
        try {
            this.scheduler = this.initializeScheduler(this.jobDetail.getKey().toString());
            this.scheduleJob(this.createTrigger(this.schedulerFacade.getCron()));
        }
        catch (SchedulerException ex) {
            throw new JobException((Exception)((Object)ex));
        }
        JobRegistry.getInstance().addJobScheduler(this.jobName, this);
    }

    private Scheduler initializeScheduler(String jobName) throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(this.getBaseQuartzProperties(jobName));
        Scheduler result = factory.getScheduler();
        result.getListenerManager().addTriggerListener((TriggerListener)this.schedulerFacade.newJobTriggerListener());
        return result;
    }

    private Properties getBaseQuartzProperties(String jobName) {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", Joiner.on((String)"_").join((Object)jobName, (Object)SCHEDULER_INSTANCE_NAME_SUFFIX, new Object[0]));
        if (!this.schedulerFacade.isMisfire()) {
            result.put("org.quartz.jobStore.misfireThreshold", "1");
        }
        this.prepareEnvironments(result);
        return result;
    }

    protected void prepareEnvironments(Properties props) {
    }

    private CronTrigger createTrigger(String cronExpression) {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        cronScheduleBuilder = this.schedulerFacade.isMisfire() ? cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed() : cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
        return (CronTrigger)TriggerBuilder.newTrigger().withIdentity(Joiner.on((String)"_").join((Object)this.jobName, (Object)CRON_TRIGGER_IDENTITY_SUFFIX, new Object[0])).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
    }

    private void scheduleJob(CronTrigger trigger) throws SchedulerException {
        if (!this.scheduler.checkExists(this.jobDetail.getKey())) {
            this.scheduler.scheduleJob(this.jobDetail, (Trigger)trigger);
        }
        this.scheduler.start();
    }

    public Date getNextFireTime() {
        List triggers;
        try {
            triggers = this.scheduler.getTriggersOfJob(this.jobDetail.getKey());
        }
        catch (SchedulerException ex) {
            return null;
        }
        Date result = null;
        for (Trigger each : triggers) {
            Date nextFireTime = each.getNextFireTime();
            if (null == nextFireTime) continue;
            if (null == result) {
                result = nextFireTime;
                continue;
            }
            if (nextFireTime.getTime() >= result.getTime()) continue;
            result = nextFireTime;
        }
        return result;
    }

    public void stopJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.pauseAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobException((Exception)((Object)ex));
        }
    }

    public void resumeJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.resumeAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobException((Exception)((Object)ex));
        }
    }

    public void triggerJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.triggerJob(this.jobDetail.getKey());
            }
        }
        catch (SchedulerException ex) {
            throw new JobException((Exception)((Object)ex));
        }
    }

    public void shutdown() {
        this.schedulerFacade.releaseJobResource();
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException ex) {
            throw new JobException((Exception)((Object)ex));
        }
    }

    public void rescheduleJob(String cronExpression) {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)Joiner.on((String)"_").join((Object)this.jobName, (Object)CRON_TRIGGER_IDENTITY_SUFFIX, new Object[0])), (Trigger)this.createTrigger(cronExpression));
            }
        }
        catch (SchedulerException ex) {
            throw new JobException((Exception)((Object)ex));
        }
    }

    public void setField(String fieldName, Object fieldValue) {
        this.jobDetail.getJobDataMap().put(fieldName, fieldValue);
    }
}

