/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api.listener;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.exception.JobTimeoutException;
import com.dangdang.ddframe.job.internal.env.TimeService;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeService;

public abstract class AbstractDistributeOnceElasticJobListener
implements ElasticJobListener {
    private final long startedTimeoutMilliseconds;
    private final Object startedWait = new Object();
    private final long completedTimeoutMilliseconds;
    private final Object completedWait = new Object();
    private GuaranteeService guaranteeService;
    private TimeService timeService = new TimeService();

    public AbstractDistributeOnceElasticJobListener(long startedTimeoutMilliseconds, long completedTimeoutMilliseconds) {
        this.startedTimeoutMilliseconds = startedTimeoutMilliseconds <= 0L ? Long.MAX_VALUE : startedTimeoutMilliseconds;
        this.completedTimeoutMilliseconds = completedTimeoutMilliseconds <= 0L ? Long.MAX_VALUE : completedTimeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void beforeJobExecuted(JobExecutionMultipleShardingContext shardingContext) {
        this.guaranteeService.registerStart(shardingContext.getShardingItems());
        if (this.guaranteeService.isAllStarted()) {
            this.doBeforeJobExecutedAtLastStarted(shardingContext);
            this.guaranteeService.clearAllStartedInfo();
            return;
        }
        long before = this.timeService.getCurrentMillis();
        try {
            Object object = this.startedWait;
            synchronized (object) {
                this.startedWait.wait(this.startedTimeoutMilliseconds);
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (this.timeService.getCurrentMillis() - before >= this.startedTimeoutMilliseconds) {
            this.guaranteeService.clearAllStartedInfo();
            throw new JobTimeoutException(this.startedTimeoutMilliseconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void afterJobExecuted(JobExecutionMultipleShardingContext shardingContext) {
        this.guaranteeService.registerComplete(shardingContext.getShardingItems());
        if (this.guaranteeService.isAllCompleted()) {
            this.doAfterJobExecutedAtLastCompleted(shardingContext);
            this.guaranteeService.clearAllCompletedInfo();
            return;
        }
        long before = this.timeService.getCurrentMillis();
        try {
            Object object = this.completedWait;
            synchronized (object) {
                this.completedWait.wait(this.completedTimeoutMilliseconds);
            }
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
        }
        if (this.timeService.getCurrentMillis() - before >= this.completedTimeoutMilliseconds) {
            this.guaranteeService.clearAllCompletedInfo();
            throw new JobTimeoutException(this.completedTimeoutMilliseconds);
        }
    }

    public abstract void doBeforeJobExecutedAtLastStarted(JobExecutionMultipleShardingContext var1);

    public abstract void doAfterJobExecutedAtLastCompleted(JobExecutionMultipleShardingContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitingTaskStart() {
        Object object = this.startedWait;
        synchronized (object) {
            this.startedWait.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaitingTaskComplete() {
        Object object = this.completedWait;
        synchronized (object) {
            this.completedWait.notifyAll();
        }
    }

    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }
}

