/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.guarantee;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeNode;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.Collection;

public class GuaranteeService {
    private final JobConfiguration jobConfiguration;
    private final JobNodeStorage jobNodeStorage;

    public GuaranteeService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
    }

    public void registerStart(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getStartedNode(each));
        }
    }

    public boolean isAllStarted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/started") && this.jobConfiguration.getShardingTotalCount() == this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/started").size();
    }

    public void clearAllStartedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/started");
    }

    public void registerComplete(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getCompletedNode(each));
        }
    }

    public boolean isAllCompleted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/completed") && this.jobConfiguration.getShardingTotalCount() == this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/completed").size();
    }

    public void clearAllCompletedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/completed");
    }
}

