/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.offset;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.offset.OffsetNode;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OffsetService {
    private final JobNodeStorage jobNodeStorage;

    public OffsetService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
    }

    public void updateOffset(int item, String offset) {
        String node = OffsetNode.getItemNode(item);
        this.jobNodeStorage.createJobNodeIfNeeded(node);
        this.jobNodeStorage.updateJobNode(node, offset);
    }

    public Map<Integer, String> getOffsets(List<Integer> items) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(items.size());
        for (int each : items) {
            String offset = this.jobNodeStorage.getJobNodeDataDirectly(OffsetNode.getItemNode(each));
            if (Strings.isNullOrEmpty((String)offset)) continue;
            result.put(each, offset);
        }
        return result;
    }
}

