/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.server;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.JobScheduler;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.server.ServerNode;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;

public class JobOperationListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ServerNode serverNode;
    private final ServerService serverService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;

    public JobOperationListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.jobName = jobConfiguration.getJobName();
        this.serverNode = new ServerNode(this.jobName);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
    }

    @Override
    public void start() {
        this.addConnectionStateListener(new ConnectionLostListener());
        this.addDataListener(new JobStoppedStatusJobListener());
        this.addDataListener(new JobShutdownStatusJobListener());
    }

    class JobShutdownStatusJobListener
    extends AbstractJobListener {
        JobShutdownStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (!JobOperationListenerManager.this.serverNode.isJobShutdownPath(path)) {
                return;
            }
            JobScheduler jobScheduler = JobRegistry.getInstance().getJobScheduler(JobOperationListenerManager.this.jobName);
            if (null != jobScheduler && TreeCacheEvent.Type.NODE_ADDED == event.getType()) {
                jobScheduler.shutdown();
                JobOperationListenerManager.this.serverService.processServerShutdown();
            }
        }
    }

    class JobStoppedStatusJobListener
    extends AbstractJobListener {
        JobStoppedStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (!JobOperationListenerManager.this.serverNode.isJobStoppedPath(path)) {
                return;
            }
            JobScheduler jobScheduler = JobRegistry.getInstance().getJobScheduler(JobOperationListenerManager.this.jobName);
            if (null == jobScheduler) {
                return;
            }
            if (TreeCacheEvent.Type.NODE_ADDED == event.getType()) {
                jobScheduler.stopJob();
            }
            if (TreeCacheEvent.Type.NODE_REMOVED == event.getType()) {
                jobScheduler.resumeJob();
                JobOperationListenerManager.this.serverService.clearJobStoppedStatus();
            }
        }
    }

    class ConnectionLostListener
    implements ConnectionStateListener {
        ConnectionLostListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            JobScheduler jobScheduler = JobRegistry.getInstance().getJobScheduler(JobOperationListenerManager.this.jobName);
            if (ConnectionState.LOST == newState) {
                jobScheduler.stopJob();
            } else if (ConnectionState.RECONNECTED == newState) {
                JobOperationListenerManager.this.serverService.persistServerOnline();
                JobOperationListenerManager.this.executionService.clearRunningInfo(JobOperationListenerManager.this.shardingService.getLocalHostShardingItems());
                if (!JobOperationListenerManager.this.serverService.isJobStoppedManually()) {
                    jobScheduler.resumeJob();
                }
            }
        }
    }
}

