/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.plugin.sharding.strategy;

import com.dangdang.ddframe.job.internal.sharding.strategy.JobShardingStrategy;
import com.dangdang.ddframe.job.internal.sharding.strategy.JobShardingStrategyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AverageAllocationJobShardingStrategy
implements JobShardingStrategy {
    @Override
    public Map<String, List<Integer>> sharding(List<String> serversList, JobShardingStrategyOption option) {
        if (serversList.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, List<Integer>> result = this.shardingAliquot(serversList, option.getShardingTotalCount());
        this.addAliquant(serversList, option.getShardingTotalCount(), result);
        return result;
    }

    private Map<String, List<Integer>> shardingAliquot(List<String> serversList, int shardingTotalCount) {
        LinkedHashMap<String, List<Integer>> result = new LinkedHashMap<String, List<Integer>>(serversList.size());
        int itemCountPerSharding = shardingTotalCount / serversList.size();
        int count = 0;
        for (String each : serversList) {
            ArrayList<Integer> shardingItems = new ArrayList<Integer>(itemCountPerSharding + 1);
            for (int i = count * itemCountPerSharding; i < (count + 1) * itemCountPerSharding; ++i) {
                shardingItems.add(i);
            }
            result.put(each, shardingItems);
            ++count;
        }
        return result;
    }

    private void addAliquant(List<String> serversList, int shardingTotalCount, Map<String, List<Integer>> shardingResult) {
        int aliquant = shardingTotalCount % serversList.size();
        int count = 0;
        for (Map.Entry<String, List<Integer>> entry : shardingResult.entrySet()) {
            if (count < aliquant) {
                entry.getValue().add(shardingTotalCount / serversList.size() * serversList.size() + count);
            }
            ++count;
        }
    }
}

