/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.bo;

import cn.com.duiba.idmaker.service.api.enums.IDMakerTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.biz.dto.StockHisDto;
import cn.com.duiba.stock.service.biz.enums.ActionTypeEnums;
import cn.com.duiba.stock.service.biz.enums.ErrorCode;
import cn.com.duiba.stock.service.biz.service.StockMonthLogService;
import cn.com.duiba.stock.service.biz.service.StockService;
import cn.com.duiba.stock.service.biz.support.DegradeTemplate;
import cn.com.duiba.stock.service.biz.support.RedisKeyFactory;
import cn.com.duiba.stock.service.biz.support.TableHelper;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.log.DBLogger;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StockBO {
    private static final Logger LOGGER = LoggerFactory.getLogger(StockBO.class);
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(StockBO.class).build();
    @Resource
    private RedisClient redisClient;
    @Resource
    private RemoteIDMakerService remoteIDMakerService;
    @Resource
    private StockService stockService;
    @Resource
    private StockMonthLogService stockMonthLogService;
    private volatile DegradeTemplate<Long> degradeTemplate;
    private static final int MAX_STOCK_CACHE_SECONDS = 600;
    private Cache<Long, Lock> lockCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    public Optional<Long> find(final long stockId) {
        this.initDegrade();
        Long stock = this.degradeTemplate.execute(stockId, new DegradeTemplate.Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long doNormal() throws Exception {
                DBTimeProfile.enter((String)"findByCache");
                try {
                    Long stock;
                    Long l = stock = StockBO.this.stockService.findByCache(stockId);
                    return l;
                }
                finally {
                    DBTimeProfile.release();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long doError() {
                try {
                    DBTimeProfile.enter((String)"error - findByDB");
                    StockDto byDB = StockBO.this.stockService.findByDB(stockId);
                    if (byDB == null || byDB.getStock() <= 0L) {
                        Long l = null;
                        return l;
                    }
                    Long l = byDB.getStock();
                    return l;
                }
                catch (Exception e1) {
                    DB_LOGGER.error(ErrorCode.SS_0102002.getCode(), e1.getMessage());
                    LOGGER.error("find from db error stockID {}", new Object[]{stockId});
                    Long l = null;
                    return l;
                }
                finally {
                    DBTimeProfile.release();
                }
            }
        });
        return Optional.fromNullable((Object)stock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDegrade() {
        if (this.degradeTemplate == null) {
            StockBO stockBO = this;
            synchronized (stockBO) {
                if (this.degradeTemplate == null) {
                    this.degradeTemplate = DegradeTemplate.newBuilder();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> newStock(long gid, long stock) {
        DubboResult nextID = null;
        try {
            DBTimeProfile.enter((String)"idmaker getNextID");
            for (int i = 0; i < 3; ++i) {
                nextID = this.remoteIDMakerService.getNextID(IDMakerTypeEnums.STOCK.getType());
                if (!nextID.isSuccess()) continue;
                break;
            }
        }
        finally {
            DBTimeProfile.release();
        }
        if (nextID == null || !nextID.isSuccess()) {
            return DubboResult.failResult((String)("add Good Stock Error By" + nextID.getMsg()));
        }
        String tableIndex = TableHelper.toMod(gid, 1024L);
        long stockId = 0L;
        StringBuilder stockIDStr = new StringBuilder(19);
        try {
            stockIDStr.append(nextID.getResult()).append(tableIndex);
            stockId = Long.valueOf(stockIDStr.toString());
        }
        catch (NumberFormatException e) {
            DB_LOGGER.error(ErrorCode.SS_0103001.getCode(), e.getMessage());
            LOGGER.error("add Good Stock Error By sequeue out of range :" + gid + ":" + stock);
            return DubboResult.failResult((String)("add Good Stock Error By sequeue out of range " + stockIDStr.toString()));
        }
        try {
            DBTimeProfile.enter((String)"stockService new stock");
            this.stockService.newStock(stockId, stock);
            DubboResult e = DubboResult.successResult((Object)stockId);
            return e;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102003.getCode(), e.getMessage());
            LOGGER.error("newStock error gid :" + gid + ":" + " stock :" + stock);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> decreaseGoodStock(long stockId, String reqBiz) {
        boolean isIdempotent = this.stockMonthLogService.idempotentCheck(stockId, reqBiz, ActionTypeEnums.DECREASE);
        if (isIdempotent) {
            return DubboResult.successResult((Object)true);
        }
        Optional<Long> longOptional = this.find(stockId);
        if (!longOptional.isPresent() || (Long)longOptional.get() <= 0L) {
            return DubboResult.successResult((Object)false);
        }
        try {
            DBTimeProfile.enter((String)"redis decr");
            Long decr = this.redisClient.decr(RedisKeyFactory.stockKey(stockId));
            if (decr < 0L) {
                DubboResult dubboResult = DubboResult.successResult((Object)false);
                return dubboResult;
            }
        }
        finally {
            DBTimeProfile.release();
        }
        try {
            DBTimeProfile.enter((String)"decreaseGoodStock");
            int count = this.stockService.decreaseGoodStock(stockId, 1L);
            if (count != 1) {
                this.rollBackCache(stockId);
                DubboResult dubboResult = DubboResult.successResult((Object)false);
                return dubboResult;
            }
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102004.getCode(), e.getMessage());
            this.rollBackCache(stockId);
            DubboResult dubboResult = DubboResult.failResult((String)("newStockMonthLog error  " + e.getMessage()));
            return dubboResult;
        }
        finally {
            DBTimeProfile.enter((String)"decreaseGoodStock");
        }
        try {
            this.newStockMonthLog(stockId, reqBiz, ActionTypeEnums.DECREASE);
        }
        catch (Exception e) {
            this.rollBackCache(stockId);
            this.rollBackDB(stockId);
        }
        return DubboResult.successResult((Object)true);
    }

    private void rollBackDB(long stockId) {
        this.stockService.increaseGoodSrock(stockId, 1L);
    }

    private void rollBackCache(long stockId) {
        try {
            this.redisClient.incr(RedisKeyFactory.stockKey(stockId));
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0103002.getCode(), e.getMessage());
            LOGGER.warn("roll back cache error " + stockId, (Throwable)e);
        }
    }

    private void newStockMonthLog(long stockId, String reqBiz, ActionTypeEnums actionTypeEnums) {
        this.stockMonthLogService.newStockMonthLog(new StockHisDto(reqBiz, actionTypeEnums.getOperation(), stockId, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> increaseItemStock(long stockId, String reqBiz) {
        boolean isIdempotent = this.stockMonthLogService.idempotentCheck(stockId, reqBiz, ActionTypeEnums.INCREASE);
        if (isIdempotent) {
            return DubboResult.successResult((Object)true);
        }
        Optional<Long> longOptional = this.find(stockId);
        if (!longOptional.isPresent()) {
            return DubboResult.successResult((Object)false);
        }
        DBTimeProfile.enter((String)"increaseGoodSrock");
        try {
            int count = this.stockService.increaseGoodSrock(stockId, 1L);
            if (count != 1) {
                DubboResult dubboResult = DubboResult.failResult((String)("increaseGoodSrock error :" + stockId));
                return dubboResult;
            }
        }
        finally {
            DBTimeProfile.release();
        }
        try {
            this.newStockMonthLog(stockId, reqBiz, ActionTypeEnums.INCREASE);
            this.rollBackCache(stockId);
        }
        catch (Exception e) {
            this.stockService.decreaseGoodStock(stockId, 1L);
        }
        return DubboResult.successResult((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> decreaseGoodStock(List<Long> stockIds, String reqBiz) {
        int count;
        long stockIdParent = stockIds.get(0);
        long stockIdChild = stockIds.get(1);
        boolean isIdempotentParent = this.stockMonthLogService.idempotentCheck(stockIdParent, reqBiz, ActionTypeEnums.DECREASE);
        boolean isIdempotentChild = this.stockMonthLogService.idempotentCheck(stockIdChild, reqBiz, ActionTypeEnums.DECREASE);
        if (isIdempotentParent && isIdempotentChild) {
            return DubboResult.successResult((Object)true);
        }
        Optional<Long> parentOptional = this.find(stockIdParent);
        if (!parentOptional.isPresent() || (Long)parentOptional.get() <= 0L) {
            return DubboResult.successResult((Object)false);
        }
        Optional<Long> childOptional = this.find(stockIdChild);
        if (!childOptional.isPresent() || (Long)childOptional.get() <= 0L) {
            return DubboResult.successResult((Object)false);
        }
        Long decrParent = this.redisClient.decr(RedisKeyFactory.stockKey(stockIdParent));
        if (decrParent < 0L) {
            return DubboResult.successResult((Object)false);
        }
        try {
            Long decrChild = this.redisClient.decr(RedisKeyFactory.stockKey(stockIdChild));
            if (decrChild < 0L) {
                this.rollBackCache(stockIdParent);
                return DubboResult.successResult((Object)false);
            }
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0103002.getCode(), e.getMessage());
            this.rollBackCache(stockIdParent);
            return DubboResult.failResult((String)"stock is less than 0");
        }
        try {
            DBTimeProfile.enter((String)"decreaseGoodStock bacth ");
            count = this.stockService.decreaseGoodStock(stockIdParent, 1L);
            if (count != 1) {
                this.rollBackCache(stockIdParent);
                this.rollBackCache(stockIdChild);
                DubboResult dubboResult = DubboResult.failResult((String)"stock is less than 0");
                return dubboResult;
            }
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0103002.getCode(), e.getMessage());
            this.rollBackCache(stockIdParent);
            this.rollBackCache(stockIdChild);
            DubboResult dubboResult = DubboResult.failResult((String)("decreaseGoodStock error  " + e.getMessage()));
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
        try {
            this.newStockMonthLog(stockIdParent, reqBiz, ActionTypeEnums.DECREASE);
        }
        catch (Exception e) {
            this.rollBackCache(stockIdParent);
            this.rollBackCache(stockIdChild);
            this.rollBackDB(stockIdParent);
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)("newStockMonthLog error  " + e.getMessage()));
        }
        try {
            DBTimeProfile.enter((String)"decreaseGoodStock bacth child ");
            count = this.stockService.decreaseGoodStock(stockIdChild, 1L);
            if (count != 1) {
                this.rollBackCache(stockIdParent);
                this.rollBackCache(stockIdChild);
                this.stockService.increaseGoodSrock(stockIdParent, 1L);
                DubboResult dubboResult = DubboResult.successResult((Object)false);
                return dubboResult;
            }
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0103002.getCode(), e.getMessage());
            this.rollBackCache(stockIdParent);
            this.rollBackCache(stockIdChild);
            this.rollBackDB(stockIdParent);
            DubboResult dubboResult = DubboResult.failResult((String)("newStockMonthLog error  " + e.getMessage()));
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
        try {
            this.newStockMonthLog(stockIdChild, reqBiz, ActionTypeEnums.DECREASE);
        }
        catch (Exception e) {
            this.rollBackCache(stockIdParent);
            this.rollBackCache(stockIdChild);
            this.rollBackDB(stockIdParent);
            this.rollBackDB(stockIdChild);
            return DubboResult.failResult((String)("newStockMonthLog error  " + e.getMessage()));
        }
        return DubboResult.successResult((Object)true);
    }
}

