/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.remoteservice.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.stock.service.biz.entity.SalesVolumeEntity;
import cn.com.duiba.stock.service.biz.enums.ErrorCode;
import cn.com.duiba.stock.service.biz.service.SaleLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.log.DBLogger;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RemoteSaleLimitServiceImpl
implements RemoteSaleLimitService {
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(RemoteSaleLimitServiceImpl.class).build();
    @Resource
    private SaleLimitService saleLimitService;

    public DubboResult<Long> findSaleCountToday(String relationType, String relationId) {
        if (relationType == null || relationId == null) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 relationType:" + relationType + " relationId :" + relationId;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            SalesVolumeEntity sale = this.saleLimitService.findSaleCountToday(relationType, relationId);
            if (sale == null) {
                return DubboResult.successResult(null);
            }
            return DubboResult.successResult((Object)sale.getSales());
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> addSaleToday(String type, String relationId, String reqbizId, int upperCount) {
        if (type == null || relationId == null || reqbizId == null || upperCount == 0) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 type:" + type + " relationId :" + relationId + " reqbizId :" + reqbizId + " upperCount :" + upperCount;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            Boolean reslut = this.saleLimitService.addSaleToday(type, relationId, reqbizId, upperCount);
            if (reslut.booleanValue()) {
                return DubboResult.successResult((Object)reslut);
            }
            return DubboResult.failResult((String)"\u5e93\u5b58 \u589e\u52a0\u5931\u8d25");
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> rollbackSaleToday(String type, String relationId, String reqbizId) {
        if (type == null || relationId == null || reqbizId == null) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 type:" + type + " relationId :" + relationId + " reqbizId :" + reqbizId;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            Boolean result = this.saleLimitService.rollbackSaleToday(type, relationId, reqbizId);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

