/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.remoteservice.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.biz.bo.StockBO;
import cn.com.duiba.stock.service.biz.dto.StockHisDto;
import cn.com.duiba.stock.service.biz.enums.ActionTypeEnums;
import cn.com.duiba.stock.service.biz.enums.ErrorCode;
import cn.com.duiba.stock.service.biz.service.StockMonthLogService;
import cn.com.duiba.stock.service.biz.service.StockService;
import cn.com.duiba.stock.service.biz.support.StockHisHelper;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.log.DBLogger;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.base.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteStockBackendServiceImpl
implements RemoteStockBackendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteStockBackendServiceImpl.class);
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(RemoteStockBackendServiceImpl.class).build();
    @Resource
    private StockService stockService;
    @Resource
    private StockMonthLogService stockMonthLogService;
    @Resource
    private StockBO stockBO;

    public DubboResult<Boolean> increaseItemStock(long stockId, long count) {
        if (stockId <= 0L || count <= 0L) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 stockId:" + stockId + " count :" + count;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            int updateCount = this.stockService.updateGoodStock(stockId, count, true);
            if (updateCount != 1) {
                return DubboResult.successResult((Object)false);
            }
            StockHisDto stockHisDto = new StockHisDto();
            stockHisDto.setActionType(ActionTypeEnums.INCREASE.getOperation());
            stockHisDto.setReqBiz(StockHisHelper.getAdminReqBiz());
            stockHisDto.setStock(count);
            stockHisDto.setStockId(stockId);
            this.stockMonthLogService.newStockMonthLog(stockHisDto);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0202001.getCode(), e.getMessage());
            LOGGER.error("updateGoodStock error :" + stockId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> decreaseItemStock(long stockId, long count) {
        if (stockId <= 0L || count <= 0L) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 stockId:" + stockId + " count :" + count;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"decreaseGoodStock");
            int updateCount = this.stockService.updateGoodStock(stockId, count, false);
            if (updateCount != 1) {
                DubboResult dubboResult = DubboResult.successResult((Object)false);
                return dubboResult;
            }
            StockHisDto stockHisDto = new StockHisDto();
            stockHisDto.setActionType(ActionTypeEnums.DECREASE.getOperation());
            stockHisDto.setReqBiz(StockHisHelper.getAdminReqBiz());
            stockHisDto.setStock(count);
            stockHisDto.setStockId(stockId);
            this.stockMonthLogService.newStockMonthLog(stockHisDto);
            DubboResult dubboResult = DubboResult.successResult((Object)true);
            return dubboResult;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0202001.getCode(), e.getMessage());
            LOGGER.error("decreaseGoodStock error : " + stockId, (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> newStock(long gid, long stock) {
        if (stock <= 0L || gid <= 0L) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 gid:" + gid + " stock :" + stock;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"newStock");
            DubboResult<Long> errorMSG = this.stockBO.newStock(gid, stock);
            return errorMSG;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0202001.getCode(), e.getMessage());
            LOGGER.error("newStock error gid " + gid + " , sotck " + stock, (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> find(long stockId) {
        if (stockId <= 0L) {
            String errorMSG = "stockID is less than 0" + stockId;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"stock bo find ");
            Optional<Long> longOptional = this.stockBO.find(stockId);
            if (longOptional.isPresent()) {
                DubboResult dubboResult = DubboResult.successResult((Object)longOptional.get());
                return dubboResult;
            }
            DubboResult dubboResult = DubboResult.failResult((String)"invalid stockID");
            return dubboResult;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0202001.getCode(), e.getMessage());
            LOGGER.error("find stock  error " + stockId);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> findTotalStock(long stockId) {
        if (stockId <= 0L) {
            String errorMSG = "stockID is less than 0" + stockId;
            DB_LOGGER.error(ErrorCode.SS_0201001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"findTotalStock ");
            Optional<Long> dtoOptional = this.stockService.findTotal(stockId);
            if (dtoOptional.isPresent()) {
                DubboResult dubboResult = DubboResult.successResult((Object)dtoOptional.get());
                return dubboResult;
            }
            DubboResult dubboResult = DubboResult.failResult((String)"invalid stockID");
            return dubboResult;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0202001.getCode(), e.getMessage());
            LOGGER.error("find stock  error :" + stockId);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

