/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.remoteservice.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.stock.service.biz.bo.StockBO;
import cn.com.duiba.stock.service.biz.enums.ErrorCode;
import cn.com.duiba.stock.service.biz.service.StockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.log.DBLogger;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteStockServiceImpl
implements RemoteStockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteStockServiceImpl.class);
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(RemoteStockServiceImpl.class).build();
    public static final int MAX_SIZE = 100;
    @Resource
    private StockService stockService;
    @Resource
    private StockBO stockBO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> find(long stockId) {
        if (stockId <= 0L) {
            String errorMSG = "stockId is less than 0";
            DB_LOGGER.error(ErrorCode.SS_0101001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"stock bo find");
            Optional<Long> dtoOptional = this.stockBO.find(stockId);
            if (dtoOptional.isPresent()) {
                DubboResult dubboResult = DubboResult.successResult((Object)dtoOptional.get());
                return dubboResult;
            }
            DubboResult dubboResult = DubboResult.failResult((String)"invalid stockID");
            return dubboResult;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102001.getCode(), "find stock  error :" + stockId + e.getMessage());
            LOGGER.error("find stock  error :" + stockId, (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Map<Long, Long>> findBatch(List<Long> stockIds) {
        if (CollectionUtils.isEmpty(stockIds) || stockIds.size() > 100) {
            String errorMSG = "stockIDs is empty or great than max size 100";
            DB_LOGGER.error(ErrorCode.SS_0101001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"findBatch");
            Map<Long, Long> results = this.stockService.findByBatch(stockIds);
            DubboResult dubboResult = DubboResult.successResult(results);
            return dubboResult;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102001.getCode(), "find error " + stockIds.toString() + e.getMessage());
            LOGGER.error("find error " + stockIds.toString(), (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> decreaseGoodStock(long stockId, String reqBiz) {
        if (stockId <= 0L || StringUtils.isBlank((CharSequence)reqBiz)) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 reqBiz:" + reqBiz + " stockId :" + stockId;
            DB_LOGGER.error(ErrorCode.SS_0101001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"decreaseGoodStock");
            DubboResult<Boolean> errorMSG = this.stockBO.decreaseGoodStock(stockId, reqBiz);
            return errorMSG;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102001.getCode(), e.getMessage());
            LOGGER.error("decreaseGoodStock", (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> decreaseGoodStock(List<Long> stockIds, String reqBiz) {
        if (CollectionUtils.isEmpty(stockIds) || stockIds.size() != 2 || StringUtils.isBlank((CharSequence)reqBiz)) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 reqBiz:" + reqBiz + " stockIds :" + (CollectionUtils.isEmpty(stockIds) ? "" : stockIds.toString());
            DB_LOGGER.error(ErrorCode.SS_0101001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"decreaseGoodStock list ");
            DubboResult<Boolean> errorMSG = this.stockBO.decreaseGoodStock(stockIds, reqBiz);
            return errorMSG;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102001.getCode(), e.getMessage());
            LOGGER.error("decreaseGoodStock list error ", (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Boolean> increaseItemStock(long stockId, String reqBiz) {
        if (StringUtils.isBlank((CharSequence)reqBiz) || stockId <= 0L) {
            String errorMSG = "\u65e0\u6548\u53c2\u6570 reqBiz:" + reqBiz + " stockId :" + stockId;
            DB_LOGGER.error(ErrorCode.SS_0101001.getCode(), errorMSG);
            return DubboResult.failResult((String)errorMSG);
        }
        try {
            DBTimeProfile.enter((String)"increaseItemStock");
            DubboResult<Boolean> errorMSG = this.stockBO.increaseItemStock(stockId, reqBiz);
            return errorMSG;
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.SS_0102001.getCode(), e.getMessage());
            LOGGER.error("increaseItemStock error ", (Throwable)e);
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

