/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.schedule;

import cn.com.duiba.stock.service.biz.dto.StockHisDto;
import cn.com.duiba.stock.service.biz.service.StockHistoryService;
import cn.com.duiba.stock.service.biz.service.StockMonthLogService;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MonthLogJob
extends AbstractSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonthLogJob.class);
    @Resource
    private StockMonthLogService stockMonthLogService;
    @Resource
    private StockHistoryService stockHistoryService;
    private static final int BATCH_SZIE = 50;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        try {
            LOGGER.info("start MonthLogJob ");
            int count = 0;
            boolean hasMore = true;
            while (hasMore) {
                List<StockHisDto> entities = this.stockMonthLogService.findPastDueData(50);
                boolean bl = hasMore = CollectionUtils.isNotEmpty(entities);
                if (!hasMore) {
                    return;
                }
                count += entities.size();
                this.stockHistoryService.batchInsert(entities);
                this.stockMonthLogService.deleteBatch(entities);
            }
            LOGGER.info(" end of MonthLogJob ,total remove data size {}", new Object[]{count});
        }
        catch (Exception e) {
            LOGGER.error("remove  past due data error ", (Throwable)e);
        }
    }
}

