/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.service.impl;

import cn.com.duiba.stock.service.biz.dao.SaleLimitDao;
import cn.com.duiba.stock.service.biz.entity.SalesVolumeEntity;
import cn.com.duiba.stock.service.biz.service.SaleLimitService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleLimitServiceImpl
implements SaleLimitService {
    @Resource
    private SaleLimitDao saleLimitDao;

    @Override
    public SalesVolumeEntity findSaleCountToday(String relationType, String relationId) {
        return this.saleLimitDao.findSaleCountToday(relationType, relationId);
    }

    @Override
    @Transactional
    public Boolean addSaleToday(String type, String relationId, String reqbizId, int upperCount) {
        try {
            SalesVolumeEntity salse = this.findSaleCountToday(type, relationId);
            if (salse == null || salse.getSales() == null) {
                SalesVolumeEntity entity = new SalesVolumeEntity();
                entity.setRelationId(relationId);
                entity.setRelationType(type);
                this.saleLimitDao.insertIntoSalesVolume(entity);
                salse.setId(entity.getId());
                salse.setSales(0L);
            } else {
                this.saleLimitDao.updateIntoSalesVolume(type, relationId, upperCount);
            }
            salse.setSales(salse.getSales() + 1L);
            this.saleLimitDao.insertIntoSalesVolumeDaylog(reqbizId, salse.getSales(), salse.getId(), "1");
            return true;
        }
        catch (Exception e) {
            DBTimeProfile.release();
            return false;
        }
    }

    @Override
    @Transactional
    public Boolean rollbackSaleToday(String type, String relationId, String reqbizId) {
        SalesVolumeEntity salse = this.saleLimitDao.selectSalesVolumeDaylog(reqbizId);
        if (salse == null) {
            return false;
        }
        this.saleLimitDao.rollbackSaleToday(salse.getId());
        this.saleLimitDao.insertIntoSalesVolumeDaylog(reqbizId, salse.getSales(), salse.getId(), "2");
        return true;
    }
}

