/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.service.impl;

import cn.com.duiba.stock.service.biz.dao.StockMonthLogDao;
import cn.com.duiba.stock.service.biz.dto.StockHisDto;
import cn.com.duiba.stock.service.biz.entity.StockMonthEntity;
import cn.com.duiba.stock.service.biz.enums.ActionTypeEnums;
import cn.com.duiba.stock.service.biz.service.StockMonthLogService;
import cn.com.duiba.stock.service.biz.support.RedisKeyFactory;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;

@Service
public class StockMonthLogServiceImpl
implements StockMonthLogService {
    @Resource
    private RedisClient redisClient;
    @Resource
    private StockMonthLogDao stockMonthLogDao;
    public static final int MAX_TTL = 3600;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idempotentCheck(long stockId, String reqBiz, ActionTypeEnums actionTypeEnums) {
        String idempotent = this.redisClient.get(RedisKeyFactory.idempotentKey(stockId, reqBiz, actionTypeEnums.getOperation()));
        if (StringUtils.isNotBlank((CharSequence)idempotent)) {
            return true;
        }
        DBTimeProfile.enter((String)"select from db idempotentCheck");
        try {
            StockMonthEntity entity = this.stockMonthLogDao.select(stockId, reqBiz, actionTypeEnums.getOperation());
            if (entity == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            DBTimeProfile.release();
        }
        return true;
    }

    @Override
    public void newStockMonthLog(StockHisDto stockHisDto) {
        StockMonthEntity stockMonthEntity = new StockMonthEntity();
        stockMonthEntity.setActionType(stockHisDto.getActionType());
        stockMonthEntity.setReqBiz(stockHisDto.getReqBiz());
        stockMonthEntity.setStockId(stockHisDto.getStockId());
        stockMonthEntity.setStock(stockHisDto.getStock());
        stockMonthEntity.setGmtCreate(stockHisDto.getGmtCreate());
        stockMonthEntity.setGmtModified(stockHisDto.getGmtModified());
        this.stockMonthLogDao.insert(stockMonthEntity);
        this.redisClient.set(RedisKeyFactory.idempotentKey(stockMonthEntity.getStockId(), stockMonthEntity.getReqBiz(), stockMonthEntity.getActionType()), String.valueOf(stockMonthEntity.getStockId()), "nx", "ex", 3600L);
    }

    @Override
    public List<StockHisDto> findPastDueData(int size) {
        if (size <= 0) {
            return Collections.emptyList();
        }
        Date lastMonth = DateUtils.addMonths((Date)new Date(), (int)-1);
        List<StockMonthEntity> stockMonthEntityList = this.stockMonthLogDao.selectPastDueData(size, lastMonth);
        if (CollectionUtils.isEmpty(stockMonthEntityList)) {
            return Collections.emptyList();
        }
        ArrayList<StockHisDto> stockHisDtoList = new ArrayList<StockHisDto>(stockMonthEntityList.size());
        for (StockMonthEntity stockMonthEntity : stockMonthEntityList) {
            StockHisDto stockHisDto = new StockHisDto(stockMonthEntity.getReqBiz(), stockMonthEntity.getActionType(), stockMonthEntity.getStockId(), stockMonthEntity.getStock());
            stockHisDtoList.add(stockHisDto);
        }
        return stockHisDtoList;
    }

    @Override
    public Integer deleteBatch(List<StockHisDto> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return 0;
        }
        Date lastMonth = DateUtils.addMonths((Date)new Date(), (int)-1);
        ArrayList list = Lists.newArrayListWithCapacity((int)entities.size());
        for (StockHisDto entity : entities) {
            list.add(entity.getStockId());
        }
        return this.stockMonthLogDao.deleteBacth(list, lastMonth);
    }
}

