/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.service.impl;

import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.biz.dao.StockDao;
import cn.com.duiba.stock.service.biz.entity.StockEntity;
import cn.com.duiba.stock.service.biz.enums.ErrorCode;
import cn.com.duiba.stock.service.biz.service.StockService;
import cn.com.duiba.stock.service.biz.support.NetHelper;
import cn.com.duiba.stock.service.biz.support.RedisKeyFactory;
import cn.com.duiba.wolf.log.DBLogger;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StockServiceImpl
implements StockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StockServiceImpl.class);
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(StockServiceImpl.class).build();
    @Resource
    private RedisClient redisClient;
    @Resource
    private StockDao stockDao;
    private Cache<Long, Lock> lockCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private Cache<Long, Lock> locktotalCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final int MAX_TIME_LOCK = 3;
    private static final int MAX_STOCK_CACHE_SECONDS = 600;

    @Override
    public int updateGoodStock(long stockId, long count, boolean isIncre) {
        Integer result = 0;
        result = isIncre ? this.stockDao.updateStockAdminIncrease(stockId, count) : this.stockDao.updateStockAdminDecrease(stockId, count);
        this.redisClient.del(RedisKeyFactory.stockKey(stockId));
        this.redisClient.del(RedisKeyFactory.stockTotalKey(stockId));
        return result;
    }

    @Override
    public int decreaseGoodStock(long stockId, long count) {
        return this.stockDao.updateStockDecrease(stockId, count);
    }

    @Override
    public int increaseGoodSrock(long stockId, long count) {
        return this.stockDao.updateStockIncrease(stockId, count);
    }

    @Override
    public Long newStock(long stockID, long stock) {
        StockEntity stockEntity = new StockEntity();
        stockEntity.setStock(stock);
        stockEntity.setStockId(stockID);
        return this.stockDao.insert(stockEntity);
    }

    @Override
    public StockDto findByDB(long stockID) {
        StockEntity stockEntity = this.stockDao.selectEntity(stockID);
        if (stockEntity == null) {
            return null;
        }
        StockDto stockDto = new StockDto();
        stockDto.setStockID(stockID);
        stockDto.setStock(stockEntity.getStock());
        stockDto.setTotalStock(stockEntity.getTotalStock());
        return stockDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long findByCache(long stockID) {
        String stock = this.redisClient.get(RedisKeyFactory.stockKey(stockID));
        if (StringUtils.isNotBlank((CharSequence)stock)) {
            return Long.valueOf(stock);
        }
        Lock lock = null;
        try {
            lock = (Lock)this.lockCache.get((Object)stockID, (Callable)new Callable<Lock>(){

                @Override
                public Lock call() throws Exception {
                    return new ReentrantLock();
                }
            });
            lock.lock();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        try {
            String set = this.redisClient.set(RedisKeyFactory.stockKeyLock(stockID), NetHelper.getLocalHostIP(), "nx", "ex", 3L);
            if (StringUtils.isNotBlank((CharSequence)set)) {
                stock = this.redisClient.get(RedisKeyFactory.stockKey(stockID));
                if (StringUtils.isNotBlank((CharSequence)stock)) {
                    Long l = Long.valueOf(stock);
                    return l;
                }
                StockEntity stockEntity = this.stockDao.selectEntity(stockID);
                if (stockEntity == null) {
                    Long l = null;
                    return l;
                }
                this.redisClient.set(RedisKeyFactory.stockKey(stockID), String.valueOf(stockEntity.getStock()), "nx", "ex", 600L);
                Long l = stockEntity.getStock();
                return l;
            }
        }
        finally {
            this.redisClient.del(RedisKeyFactory.stockKeyLock(stockID));
            if (lock != null) {
                lock.unlock();
            }
        }
        stock = this.selfSpin(stockID);
        if (StringUtils.isBlank((CharSequence)stock)) {
            return null;
        }
        return Long.valueOf(stock);
    }

    private String selfSpin(long stockID) {
        String stock = null;
        for (int i = 0; i < 3; ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                stock = this.redisClient.get(RedisKeyFactory.stockKey(stockID));
                if (!StringUtils.isNotBlank((CharSequence)stock)) continue;
                break;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return stock;
    }

    private String totalSelfSpin(long stockID) {
        String totalStock = null;
        for (int i = 0; i < 3; ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                totalStock = this.redisClient.get(RedisKeyFactory.stockTotalKey(stockID));
                if (!StringUtils.isNotBlank((CharSequence)totalStock)) continue;
                break;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return totalStock;
    }

    @Override
    public Map<Long, Long> findByBatch(List<Long> stockIds) {
        HashMap<Long, Long> maps = new HashMap<Long, Long>(stockIds.size());
        for (Long stockId : stockIds) {
            try {
                Long stock = this.findByCache(stockId);
                maps.put(stockId, stock);
            }
            catch (Exception e) {
                DB_LOGGER.error(ErrorCode.SS_0103002.getCode(), e.getMessage());
                LOGGER.error("find by cache error : {} ", new Object[]{stockId});
            }
        }
        return maps;
    }

    @Override
    public void removeCache(long stockID) {
        this.redisClient.del(RedisKeyFactory.stockKey(stockID));
    }

    @Override
    public String findFromCache(long stockID) {
        return this.redisClient.get(RedisKeyFactory.stockKey(stockID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Long> findTotal(long stockID) {
        String totalStock = this.redisClient.get(RedisKeyFactory.stockTotalKey(stockID));
        if (StringUtils.isNotBlank((CharSequence)totalStock)) {
            return Optional.of((Object)Long.valueOf(totalStock));
        }
        Lock lock = null;
        try {
            lock = (Lock)this.locktotalCache.get((Object)stockID, (Callable)new Callable<Lock>(){

                @Override
                public Lock call() throws Exception {
                    return new ReentrantLock();
                }
            });
            lock.lock();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        try {
            String set = this.redisClient.set(RedisKeyFactory.stockTotalKeyLock(stockID), NetHelper.getLocalHostIP(), "nx", "ex", 3L);
            if (StringUtils.isNotBlank((CharSequence)set)) {
                totalStock = this.redisClient.get(RedisKeyFactory.stockTotalKey(stockID));
                if (StringUtils.isNotBlank((CharSequence)totalStock)) {
                    Optional optional = Optional.of((Object)stockID);
                    return optional;
                }
                StockEntity stockEntity = this.stockDao.selectEntity(stockID);
                if (stockEntity == null) {
                    Optional<Long> optional = null;
                    return optional;
                }
                this.redisClient.set(RedisKeyFactory.stockTotalKey(stockID), String.valueOf(stockEntity.getStock()), "nx", "ex", 600L);
                Optional optional = Optional.of((Object)stockEntity.getTotalStock());
                return optional;
            }
        }
        finally {
            try {
                this.redisClient.del(RedisKeyFactory.stockTotalKeyLock(stockID));
            }
            catch (Exception e) {
                LOGGER.error("del redis lock error ", (Throwable)e);
            }
            if (lock != null) {
                lock.unlock();
            }
        }
        totalStock = this.totalSelfSpin(stockID);
        if (StringUtils.isBlank((CharSequence)totalStock)) {
            return null;
        }
        return Optional.of((Object)Long.valueOf(totalStock));
    }
}

