/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegradeTemplate<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DegradeTemplate.class);
    private Cache<Object, Lock> build = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public static DegradeTemplate newBuilder() {
        return new DegradeTemplate();
    }

    public T execute(Object lockKey, Handler handler) {
        T result = null;
        try {
            result = handler.doNormal();
        }
        catch (Exception e) {
            LOGGER.error("handler error ", (Throwable)e);
            try {
                Lock lock = (Lock)this.build.get(lockKey, (Callable)new Callable<Lock>(){

                    @Override
                    public Lock call() throws Exception {
                        return new ReentrantLock();
                    }
                });
                lock.lock();
                try {
                    result = handler.doError();
                }
                catch (Exception ee) {
                    LOGGER.error("handler error ", (Throwable)ee);
                    throw new IllegalStateException(ee);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (ExecutionException e1) {
                throw new IllegalStateException("get lock error ", e);
            }
        }
        return result;
    }

    public static interface Handler<T> {
        public T doNormal() throws Exception;

        public T doError();
    }
}

