/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.support;

import com.google.common.base.Splitter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class StockServiceConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(StockServiceConstants.class);
    private static final String MACHINE_ID_CONFIG = "stock.allow.gtype";
    @Value(value="${stock.allow.gtype}")
    private String allowGtype;

    public String getAllowGtype() {
        return this.allowGtype;
    }

    public void setAllowGtype(String allowGtype) {
        this.allowGtype = allowGtype;
    }

    public boolean isValidGType(int gtype) {
        if (StringUtils.isBlank((CharSequence)this.allowGtype)) {
            return false;
        }
        Iterable split = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.allowGtype);
        for (String s : split) {
            if (Integer.valueOf(gtype) != gtype) continue;
            return true;
        }
        return false;
    }
}

