/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.biz.support;

import com.google.common.base.Preconditions;

public final class TableHelper {
    public static final int DEFAULT_TABLE_NUM = 1024;

    public static String toMod(long num, long mod) {
        Preconditions.checkArgument((mod > 0L ? 1 : 0) != 0, (Object)"mod value is less than 0");
        long newNum = num <= 0L ? Math.abs(num) : num;
        long length = TableHelper.getLength(mod);
        long modNum = newNum % mod;
        int realLength = TableHelper.getLength(modNum);
        long differenceValue = length - (long)realLength;
        if (differenceValue <= 0L) {
            return String.valueOf(modNum);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while ((long)i < differenceValue) {
            stringBuilder.append("0");
            ++i;
        }
        stringBuilder.append(String.valueOf(modNum));
        return stringBuilder.toString();
    }

    private static int getLength(long mod) {
        if (mod < 10L) {
            return 1;
        }
        if (mod < 100L) {
            return 2;
        }
        if (mod < 1000L) {
            return 3;
        }
        if (mod < 10000L) {
            return 4;
        }
        if (mod < 100000L) {
            return 5;
        }
        throw new IllegalArgumentException("mod is out of support , must less than 100000. current : " + mod);
    }

    public static void main(String[] args) {
        String s = TableHelper.toMod(1000L, 100L);
        String s1 = TableHelper.toMod(1012L, 1000L);
        String s2 = TableHelper.toMod(101200L, 10000L);
        String s3 = TableHelper.toMod(1999L, 1000L);
        System.out.println(s);
        System.out.println(s1);
        System.out.println(s2);
        System.out.println(s3);
    }
}

