/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.schedule;

import com.dangdang.ddframe.job.spring.util.AopTargetUtils;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.PropertySettingJobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public final class SpringJobFactory
extends PropertySettingJobFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringJobFactory.class);
    private static ApplicationContext applicationContext;

    public static void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Preconditions.checkNotNull((Object)applicationContext, (Object)"applicationContext cannot be null, should call setApplicationContext first.");
        Job job = null;
        try {
            for (Job each : applicationContext.getBeansOfType(Job.class).values()) {
                if (AopUtils.getTargetClass((Object)each) != bundle.getJobDetail().getJobClass()) continue;
                job = each;
                break;
            }
            if (null == job) {
                throw new NoSuchBeanDefinitionException("");
            }
        }
        catch (BeansException ex) {
            log.info("Elastic job: cannot found bean for class: '{}'. This job is not managed for spring.", (Object)bundle.getJobDetail().getJobClass().getCanonicalName());
            return super.newJob(bundle, scheduler);
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll((Map)scheduler.getContext());
        jobDataMap.putAll((Map)bundle.getJobDetail().getJobDataMap());
        jobDataMap.putAll((Map)bundle.getTrigger().getJobDataMap());
        Job target = (Job)AopTargetUtils.getTarget(job);
        this.setBeanProps(target, jobDataMap);
        return target;
    }
}

