/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.reg.spring.placeholder;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public final class PlaceholderResolved {
    private static final Logger log = LoggerFactory.getLogger(PlaceholderResolved.class);
    private final Map<String, PropertySourcesPlaceholderConfigurer> placeholderMap;

    public PlaceholderResolved(ListableBeanFactory beanFactory) {
        this.placeholderMap = beanFactory.getBeansOfType(PropertySourcesPlaceholderConfigurer.class);
    }

    public String getResolvePlaceholderText(String text) {
        if (this.placeholderMap.isEmpty()) {
            return text;
        }
        IllegalArgumentException missingException = null;
        for (Map.Entry<String, PropertySourcesPlaceholderConfigurer> entry : this.placeholderMap.entrySet()) {
            PropertySourcesPropertyResolver propertyResolver;
            try {
                propertyResolver = new PropertySourcesPropertyResolver(entry.getValue().getAppliedPropertySources());
            }
            catch (IllegalStateException ex) {
                continue;
            }
            catch (NoSuchMethodError ex) {
                try {
                    propertyResolver = this.getPropertyResolverBeforeSpring4(entry.getValue());
                }
                catch (ReflectiveOperationException e) {
                    log.warn("Cannot get placeholder resolver.");
                    return text;
                }
            }
            try {
                return propertyResolver.resolveRequiredPlaceholders(text);
            }
            catch (IllegalArgumentException ex) {
                missingException = ex;
            }
        }
        if (null == missingException) {
            return text;
        }
        throw missingException;
    }

    private PropertySourcesPropertyResolver getPropertyResolverBeforeSpring4(PropertySourcesPlaceholderConfigurer placeholderConfigurer) throws ReflectiveOperationException {
        return new PropertySourcesPropertyResolver((PropertySources)PropertySourcesPlaceholderConfigurer.class.getField("propertySources").get(placeholderConfigurer));
    }
}

