package cn.com.duiba.stock.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.stock.service.api.dto.JbpStockRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 聚宝盆卡券库存远程服务接口
 */
@AdvancedFeignClient
public interface RemoteJbpStockRecordService {

    /**
     * 根据ID查询聚宝盆库存记录
     *
     * @param id 主键ID
     * @return 库存记录DTO
     */
    DubboResult<JbpStockRecordDto> getById(Long id);

    /**
     * 根据唯一键查询聚宝盆库存记录
     *
     * @param itemId mng商品id
     * @param demandId 聚宝盆需求id
     * @param jbpGoodsId 聚宝盆商品id
     * @return 库存记录DTO
     */
    DubboResult<JbpStockRecordDto> getByUniqueKey(Long itemId, Long demandId, Long jbpGoodsId);

    /**
     * 根据itemId查询聚宝盆库存记录列表
     *
     * @param itemId mng商品id
     * @return 库存记录DTO列表
     */
    DubboResult<List<JbpStockRecordDto>> getListByItemId(Long itemId);

    /**
     * 根据itemId列表批量查询聚宝盆库存记录列表
     *
     * @param itemIds mng商品id列表
     * @return 库存记录DTO列表
     */
    DubboResult<List<JbpStockRecordDto>> getListByItemIds(List<Long> itemIds);

    /**
     * 根据jbpGoodsId查询聚宝盆库存记录列表
     *
     * @param jbpGoodsId 聚宝盆商品id
     * @return 库存记录DTO列表
     */
    DubboResult<List<JbpStockRecordDto>> getListByJbpGoodsId(Long jbpGoodsId);

    /**
     * 创建聚宝盆库存记录
     *
     * @param dto 库存记录DTO
     * @return 记录ID
     */
    DubboResult<Long> createRecord(JbpStockRecordDto dto);

    /**
     * 增加已使用库存
     *
     * @param id 主键ID
     * @param count 增加的数量
     * @return 是否成功
     */
    DubboResult<Boolean> increaseUsedStock(Long id, Long count);

    /**
     * 增加已回退库存
     *
     * @param id 主键ID
     * @param count 增加的数量
     * @return 是否成功
     */
    DubboResult<Boolean> increaseRolledBackStock(Long id, Long count);

    /**
     * 增加总库存
     *
     * @param id 主键ID
     * @param count 增加的数量
     * @return 是否成功
     */
    DubboResult<Boolean> increaseTotalStock(Long id, Long count);

    /**
     * 减少总库存
     *
     * @param id 主键ID
     * @param count 减少的数量
     * @return 是否成功
     */
    DubboResult<Boolean> decreaseTotalStock(Long id, Long count);
}

