package cn.com.duiba.supplier.center.api.mq;


import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

/**
 * Created by hww on 2018/12/10 2:07 PM.
 */
public class SupplyOrderMqParams implements Serializable {

    private static final long serialVersionUID = 7078932614018178069L;
    //供应商系统消息 TAG supplier-center
    public static final String TAG_SUPPLIER_CONFIRM_ORDER = "confirmOrder";
    public static final String TAG_SUPPLIER_CANCEL_ORDER = "cancelOrder";
    public static final String TAG_SUPPLIER_CONFIRM_RECEIVED = "confirmReceived";

    private Long supplyOrderNum;

    private String cancelReason;

    public Long getSupplyOrderNum() {
        return supplyOrderNum;
    }

    public void setSupplyOrderNum(Long supplyOrderNum) {
        this.supplyOrderNum = supplyOrderNum;
    }

    public String getCancelReason() {
        return cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public byte[] encode(SupplyOrderMqParams msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }



}
