package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.request.PurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.AliPayPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.CouponPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.ObjectPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.PhoneBillPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.PhoneFlowPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.QBPurchaseRequest;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;

/**
 * Created by hww on 2018/11/28 11:58 AM.
 */
@AdvancedFeignClient
public interface RemoteSupplyOrdersService {

    /**
     * 下采购单接口
     * 构建对应的下单请求类进行下单
     * @see QBPurchaseRequest        Q币
     * @see ObjectPurchaseRequest    实物
     * @see CouponPurchaseRequest    优惠券
     * @see AliPayPurchaseRequest    优惠券
     * @see PhoneBillPurchaseRequest 手机话费
     * @see PhoneFlowPurchaseRequest 手机流量
     */
    PurchaseOrderResponse purchaseOrder(PurchaseRequest request);

}
