package cn.com.duiba.supplier.center.api.request.purchase;

import cn.com.duiba.supplier.center.api.enums.PurchaseTypeEnum;
import cn.com.duiba.supplier.center.api.params.SkuParam;
import cn.com.duiba.supplier.center.api.request.PurchaseRequest;

/**
 * 优惠券下单请求参数
 * Created by hww on 2018/12/3 1:55 PM.
 */
public class CouponPurchaseRequest extends PurchaseRequest {

    private static final long serialVersionUID = -3813320791564793811L;
    /** 必传 购买的商品 */
    private SkuParam sku;

    /** 非必传 来自活动的订单 需要传couponId */
    private Long couponId;

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public SkuParam getSku() {
        return sku;
    }

    public void setSku(SkuParam sku) {
        this.sku = sku;
    }

    @Override
    public String getApiMethodName() {
        return PurchaseTypeEnum.COUPON.name();
    }
}
