package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SupplyOrdersDto;
import cn.com.duiba.supplier.center.api.request.order.QueryOrderListRequest;

import javax.annotation.CheckForNull;
import java.util.List;


/**
 * Created by hww on 2018/12/13 3:16 PM.
 */
@AdvancedFeignClient
public interface RemoteSupplyOrdersBackedService {

    /**
     * 根据采购单号查询采购单
     */
    @CheckForNull
    SupplyOrdersDto findBySupplyOrderNum(Long supplyOrderNum);

    /**
     * 根据第三方订单号查询采购单
     */
    @CheckForNull
    SupplyOrdersDto findByThirdOrderNum(String thirdOrderNum);

    /**
     * 分页查询采购单
     */
    Page<SupplyOrdersDto> findPage(QueryOrderListRequest request);

    /**
     * 根据供应商ID及商品类型查询待发货的订单
     */
    @CheckForNull
    List<SupplyOrdersDto> selectWaitSendBySupplierId(Long supplierId, String itemType);

}
