package cn.com.duiba.supplier.center.api.response;


import cn.com.duiba.supplier.center.api.enums.ResultCodeEnums;

/**
 * Created by hww on 2018/11/28 12:03 PM.
 */
public class CancelOrderResponse extends AbstractResponse {

    private static final long serialVersionUID = -2489614306940166943L;

    public static CancelOrderResponse success() {
        CancelOrderResponse response = new CancelOrderResponse();
        response.setSuccess(true);
        response.setResultCode(ResultCodeEnums.RC_00001.getCode());
        response.setResultMessage(ResultCodeEnums.RC_00001.getMessage());
        return response;
    }

    public static CancelOrderResponse fail() {
        return fail(ResultCodeEnums.RC_00002);
    }

    public static CancelOrderResponse fail(ResultCodeEnums code) {
        return fail(code.getCode(), code.getMessage());
    }

    public static CancelOrderResponse fail(String code, String message) {
        CancelOrderResponse response = new CancelOrderResponse();
        response.setSuccess(false);
        response.setResultCode(code);
        response.setResultMessage(message);
        return response;
    }



}
