package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import javax.servlet.http.HttpServletRequest;

/**
 * @program: supplier-center
 * @description: 供应商接口回调
 * @author: Simba
 * @create: 2018-12-19 19:33
 **/
@AdvancedFeignClient
public interface RemoteSupplierCallbackService {

    /**
     * 支付宝支付回调
     * @param supplyDeliveryNum
     * @return
     */
    boolean alipayCallback(String supplyDeliveryNum, boolean isSuccess, String msg) throws Exception;

    /**
     * 话费回调
     * @param supplyDeliveryNum
     * @param request
     * @return
     * @throws Exception
     */
    boolean phonebillCallback(String supplyDeliveryNum, HttpServletRequest request) throws Exception;

    /**
     * QB回调
     * @param supplyDeliveryNum
     * @param request
     * @return
     */
    boolean qbCallback(String supplyDeliveryNum, HttpServletRequest request) throws Exception;
}

