package cn.com.duiba.supplier.center.api.enums;

/**
 * 支持的采购单下单类型
 */
public enum PurchaseTypeEnum {

    OBJECT("实物订单", "object"),
    ;

    private String desc;
    private String itemType;

    PurchaseTypeEnum(String desc, String itemType) {
        this.desc = desc;
        this.itemType = itemType;
    }

    public String getDesc() {
        return desc;
    }

    public String getItemType() {
        return itemType;
    }

    public static String getItemType(String name) {
        return valueOf(name).itemType;
    }

}
