package cn.com.duiba.supplier.center.api.dto.item;

import java.io.Serializable;
import java.util.Date;

/**
* 供应商商品表
*/
public class SupplyItemDto implements Serializable {
    private static final long serialVersionUID = 1597147550815305644L;

    /**
    * ID
    */
    private Long id;

    /**
    * 兑吧商品id
    */
    private Long itemId;

    /**
    * 兑吧商品sku id
    */
    private Long skuId;

    /**
    * 第三方供应商标识: 1:京东
    */
    private Integer supplierType;

    /**
    * 第三方商品标识
    */
    private String thirdItemId;

    /**
    * 第三方商品类型
    */
    private String thirdType;

    /**
    * 第三方商品扩展字段, 含：channel_price协议价，market_price建议零售价，face_price划线价，express_price运费价（若单商品有运费）
    */
    private String thirdExtJson;

    /**
    * 是否可售，0：否；1，是
    */
    private Integer thirdOnsale;

    /**
    * 状态 0:下架 1:上架
    */
    private Integer thirdEnable;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSupplierType(Integer supplierType) {
        this.supplierType = supplierType;
    }

    public Integer getSupplierType() {
        return supplierType;
    }

    public void setThirdItemId(String thirdItemId) {
        this.thirdItemId = thirdItemId;
    }

    public String getThirdItemId() {
        return thirdItemId;
    }

    public void setThirdType(String thirdType) {
        this.thirdType = thirdType;
    }

    public String getThirdType() {
        return thirdType;
    }

    public void setThirdExtJson(String thirdExtJson) {
        this.thirdExtJson = thirdExtJson;
    }

    public String getThirdExtJson() {
        return thirdExtJson;
    }

    public void setThirdOnsale(Integer thirdOnsale) {
        this.thirdOnsale = thirdOnsale;
    }

    public Integer getThirdOnsale() {
        return thirdOnsale;
    }

    public void setThirdEnable(Integer thirdEnable) {
        this.thirdEnable = thirdEnable;
    }

    public Integer getThirdEnable() {
        return thirdEnable;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

