package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.request.PurchaseRequest;
import cn.com.duiba.supplier.center.api.request.purchase.ObjectPurchaseRequest;
import cn.com.duiba.supplier.center.api.response.CancelOrderResponse;
import cn.com.duiba.supplier.center.api.response.ConfirmOrderResponse;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;
import cn.com.duiba.supplier.center.api.response.ReceivedOrderResponse;

/**
 * Created by hww on 2018/11/28 11:58 AM.
 */
@AdvancedFeignClient
public interface RemoteSupplyOrdersService {

    /**
     * 下采购单接口,预占库存
     * 构建对应的下单请求类进行下单
     * @see ObjectPurchaseRequest    实物
     */
    PurchaseOrderResponse purchaseOrder(PurchaseRequest request);

    /**
     * 确认预占采购单
     */
    ConfirmOrderResponse confirmOrder(Long supplyOrderNum);

    /**
     * 取消预占采购单
     */
    CancelOrderResponse cancelOrder(Long supplyOrderNum, String cancelReason);

    /**
     * 确认收货
     */
    ReceivedOrderResponse confirmReceived(Long supplyOrderNum);







}
