package cn.com.duiba.supplier.center.api.remoteservice.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.supplier.center.api.params.ReceiverParam;

/**
 * 针对手机端调用，隔离容器线程池，避免网络问题导致容器线程池占满
 * Created by xutao on 2019/6/13.
 */
@AdvancedFeignClient
public interface RemoteJdItemService {
    /**
     * 查询单个sku id有没有库存，用于手机端下单
     * @param jdSkuId
     * @return
     * @throws BizException
     */
    @FeignHystrixCommand(threadPoolKey = "jd-http-pool")
    @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value="50")
    boolean hasStock(Long jdSkuId) throws BizException;

    /**
     * 查询单个sku id是否可售，用于手机端下单
     * @param jdSkuId
     * @return
     * @throws BizException
     */
    @FeignHystrixCommand(threadPoolKey = "jd-http-pool")
    @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value="50")
    boolean hasOnSale(Long jdSkuId) throws BizException;

    /**
     * 查询单个商品区域限购
     * @param jdSkuId
     * @param province
     * @param city
     * @param county
     * @param town
     * @return
     * @throws BizException
     */
    @FeignHystrixCommand(threadPoolKey = "jd-http-pool")
    @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value="50")
    boolean hasNoAreaLimit(String jdSkuId, String province, String city, String county, String town) throws BizException;

    /**
     *
     * @param duibaAddress
     * @param thirdOrderNum
     * @return
     * @throws BizException
     */
    @FeignHystrixCommand(threadPoolKey = "jd-http-pool")
    @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value="50")
    ReceiverParam findJdAddress(String duibaAddress, String thirdOrderNum) throws BizException;
}
