package cn.com.duiba.supplier.center.api.response;


import cn.com.duiba.supplier.center.api.enums.ErrorCodeEnums;

/**
 * Created by hww on 2018/11/28 12:03 PM.
 */
public class ConfirmOrderResponse extends AbstractResponse {

    private static final long serialVersionUID = -2489614306940166943L;

    public static ConfirmOrderResponse success() {
        ConfirmOrderResponse response = new ConfirmOrderResponse();
        response.setSuccess(true);
        response.setResultCode(ErrorCodeEnums.RC_00001.getCode());
        response.setResultMessage(ErrorCodeEnums.RC_00001.getMessage());
        return response;
    }

    public static ConfirmOrderResponse fail() {
        return fail(ErrorCodeEnums.RC_00002);
    }

    public static ConfirmOrderResponse fail(ErrorCodeEnums code) {
        return fail(code.getCode(), code.getMessage());
    }

    public static ConfirmOrderResponse fail(String code, String message) {
        ConfirmOrderResponse response = new ConfirmOrderResponse();
        response.setSuccess(false);
        response.setResultCode(code);
        response.setResultMessage(message);
        return response;
    }



}
