package cn.com.duiba.supplier.center.api.enums;

import com.google.common.collect.ImmutableSet;

/**
 * 支持的采购单下单类型
 */
public enum PurchaseTypeEnum {

    OBJECT("实物订单", "object"),

    COUPON("优惠券", "coupon"),

    QB("Q币", "qb"),

    PHONE_BILL("手机话费", "phonebill"),

    PHONE_FLOW("手机流量", "phoneflow"),

    ALI_PAY("支付宝", "alipay"),
    ;

    private String desc;
    private String itemType;

    PurchaseTypeEnum(String desc, String itemType) {
        this.desc = desc;
        this.itemType = itemType;
    }

    public String getDesc() {
        return desc;
    }

    public String getItemType() {
        return itemType;
    }

    private static final ImmutableSet<String> NO_STOCK_TYPE = ImmutableSet.of(
            PurchaseTypeEnum.ALI_PAY.name(),
            PurchaseTypeEnum.PHONE_BILL.name(),
            PurchaseTypeEnum.PHONE_FLOW.name(),
            PurchaseTypeEnum.QB.name()
            );

    public static boolean isNoStockType(String name) {
        return NO_STOCK_TYPE.contains(name);
    }

    public static String getItemType(String name) {
        return valueOf(name).itemType;
    }

}
