package cn.com.duiba.supplier.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 系统返回码
 * 返回码格式为 AABBB
 * AA:业务模块
 * BBB:具体错误类型
 */
public enum ResultCodeEnums {

    /** 00XXX 通用模块返回码 */
    RC_00001("00001", "调用成功"),
    RC_00002("00002", "调用失败"),

    /** 01XXX 采购单模块 */
    RC_01001("01001", "此类型无法下单"),
    RC_01002("01002", "订单号不能为空"),
    RC_01003("01003", "第三方订单号不能为空"),
    RC_01004("01004", "分销商id不能为空"),
    RC_01005("01005", "下单ip不能为空"),

    //支付宝参数校验
    RC_01006("01006", "支付宝账号不能为空"),
    RC_01007("01007", "用户姓名不能为空"),
    RC_01008("01008", "支付宝账号信息包含非法字符'^|&'"),
    RC_01009("01009", "支付宝账号格式错误"),
    RC_01010("01010", "非法支付宝充值金额"),
    RC_01011("01011", "无AliPayOfficial供应商开启"),

    RC_01012("01012", "购买商品不支持"),
    RC_01013("01013", "没有合适供应商,无法兑换"),

    //优惠券参数校验
    RC_01014("01014", "sku不能为空"),
    RC_01015("01015", "优惠券id不能为空"),
    RC_01016("01016", "用户id不能为空"),

    RC_01017("01017", "购买的商品不存在"),
    RC_01018("01018", "sku商品不存在"),
    RC_01019("01019", "兑换券已经用完"),

    //实物参数校验
    RC_01020("01020", "收货省份信息不能为空"),
    RC_01021("01021", "收货城市信息不能为空"),
    RC_01022("01022", "收货县区信息不能为空"),
    RC_01023("01023", "收货街道信息不能为空"),
    RC_01024("01024", "收货地址不能为空"),
    RC_01025("01025", "收货人姓名不能为空"),
    RC_01026("01026", "收货联系电话不能为空"),

    RC_01027("01027", "不能购买不同供应商的商品"),
    RC_01028("01028", "商品扣库存失败"),
    RC_01029("01029", "运费模板不存在，匹配失败！"),

    //手机话费下单校验
    RC_01030("01030", "手机号码错误"),
    RC_01031("01031", "无法获取手机号码归属地"),
    RC_01032("01032", "无法获取手机号码运营商"),
    RC_01033("01033", "充值面值错误"),
    RC_01034("01034", "浙江移动暂时不支持此面值充值"),
    RC_01035("01035", "四川联通暂时不支持此面值充值"),
    RC_01036("01036", "湖北联通暂时不支持此面值充值"),
    RC_01037("01037", "收货地址不能为空"),

    //手机流量校验
    RC_01038("01038", "流量产品id不能为空"),

    //q币下单校验
    RC_01039("01039", "qq号码错误"),
    RC_01040("01040", "Q币数量必须大于0"),

    //确认采购单
    RC_01041("01041", "商品子订单不存在"),
    RC_01042("01042", "充值供应商待结算账户失败"),
    RC_01043("01043", "更新采购贷为待发货状态失败"),
    RC_01044("01044", "创建发货单失败"),
    RC_01045("01045", "更新发货单id失败"),

    //取消采购单
    RC_01046("01046", "采购单不存在"),
    RC_01047("01047", "采购单状态错误"),
    RC_01048("01048", "更新采购单状态失败"),

    //确认发货
    RC_01049("01049", "扣除供应商待结算账户失败"),
    RC_01050("01050", "充值供应商资产账户失败"),

    ;

    private String code;

    private String message;

    ResultCodeEnums (String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    private static Map<String, ResultCodeEnums> ALL_MAP;

    static {
        Map<String, ResultCodeEnums> temp = Maps.newHashMap();
        Arrays.stream(values()).forEach(code -> temp.put(code.getCode(), code));
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static ResultCodeEnums findByCode(String code) {
        return ALL_MAP.get(code);
    }

}
