package cn.com.duiba.supplier.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 采购单主订单状态枚举
 */
public enum SupplyOrderStatusEnum {

    CREATE(0, "初始化-创建"),

    WAIT_PAY(1, "待付款"),

    WAIT_SEND(2, "待供应商处理"),

    WAIT_SUPPLIER_SEND(3, "待供应商发货"),

    AFTER_SEND(4, "已发货"),

    SUCCESS(5, "订单完结-交易成功"),

    FAIL(6, "订单完结-交易失败"),

    ;

    public static final ImmutableMap<Integer, SupplyOrderStatusEnum> SUPPLY_ORDER_STATUS_MAP;

    static {
        Map<Integer, SupplyOrderStatusEnum> temp = Maps.newHashMap();
        for (SupplyOrderStatusEnum supplyOrderStatusEnum : values()) {
            temp.put(supplyOrderStatusEnum.getCode(), supplyOrderStatusEnum);
        }
        SUPPLY_ORDER_STATUS_MAP = ImmutableMap.copyOf(temp);
    }

    private Integer code;

    private String desc;

    SupplyOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
