package cn.com.duiba.supplier.center.api.dto.order;

import java.io.Serializable;

/**
 * 京东订单详情
 */
public class JdOrderDetailDto implements Serializable {
    private static final long serialVersionUID = -6378342424075138402L;

    /**
     * 父订单号。为0时，此订单为父单。
     */
    private Integer pOrder;
    /**
     * 订单状态。0为取消订单  1为有效。
     */
    private Integer orderState;
    /**
     * 京东订单编号
     */
    private Long jdOrderId;
    /**
     * 物流状态。0 是新建  1是妥投  2是拒收
     */
    private Integer state;
    /**
     * 预占确认状态。0没确认预占。 1为确认预占
     */
    private Integer submitState;
    /**
     * 订单类型。1是父订单  2是子订单。
     */
    private Integer type;

    /**
     * 运费
     */
    private Double freight;
    /**
     * 订单总金额
     */
    private Double orderPrice;
    /**
     * 订单未含税金额
     */
    private Double orderNakedPrice;
    /**
     * 订单税额
     */
    private Double orderTaxPrice;
    /**
     * 加密后的联系方式
     * 查询参数queryExts中包含mobile
     */
    private String mobile;
    /**
     * 订单类别。
     * 查询参数queryExts中包含orderType。文档列举了相关枚举值，暂时不需要该字段，故为补充相应枚举类
     */
    private Integer orderType;
    /**
     * 订单创建时间。
     * 查询参数queryExts中包含createOrderTime。
     * 输出格式为“yyyy-MM-dd hh:mm:ss”
     */
    private String createOrderTime;
    /**
     * 订单创建时间。
     * 查询参数queryExts中包含createOrderTime。
     * 输出格式为“yyyy-MM-dd hh:mm:ss”
     * 未完成时，此参数返回null。
     */
    private String finishTime;
    /**
     * 京东订单状态
     */
    private Integer jdOrderState;
    /**
     * 加密后的收货地址。
     * 查询参数queryExts中包含address。
     * 解密方式：AD+client_id前6位
     * 解密规则：DES/CBC/PKCS5Padding，Hex
     */
    private String address;
    /**
     * 加密后的姓名。
     * 查询参数queryExts中包含name。
     * 解密方式：NA+client_id前6位
     */
    private String name;

    public Integer getpOrder() {
        return pOrder;
    }

    public void setpOrder(Integer pOrder) {
        this.pOrder = pOrder;
    }

    public Integer getOrderState() {
        return orderState;
    }

    public void setOrderState(Integer orderState) {
        this.orderState = orderState;
    }

    public Long getJdOrderId() {
        return jdOrderId;
    }

    public void setJdOrderId(Long jdOrderId) {
        this.jdOrderId = jdOrderId;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getSubmitState() {
        return submitState;
    }

    public void setSubmitState(Integer submitState) {
        this.submitState = submitState;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Double getFreight() {
        return freight;
    }

    public void setFreight(Double freight) {
        this.freight = freight;
    }

    public Double getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(Double orderPrice) {
        this.orderPrice = orderPrice;
    }

    public Double getOrderNakedPrice() {
        return orderNakedPrice;
    }

    public void setOrderNakedPrice(Double orderNakedPrice) {
        this.orderNakedPrice = orderNakedPrice;
    }

    public Double getOrderTaxPrice() {
        return orderTaxPrice;
    }

    public void setOrderTaxPrice(Double orderTaxPrice) {
        this.orderTaxPrice = orderTaxPrice;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public String getCreateOrderTime() {
        return createOrderTime;
    }

    public void setCreateOrderTime(String createOrderTime) {
        this.createOrderTime = createOrderTime;
    }

    public String getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public Integer getJdOrderState() {
        return jdOrderState;
    }

    public void setJdOrderState(Integer jdOrderState) {
        this.jdOrderState = jdOrderState;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
