package cn.com.duiba.supplier.center.api.remoteservice.supplier;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.supplier.SupplierInfoDto;
import cn.com.duiba.supplier.center.api.dto.supplier.SupplierParam;

import java.util.List;

/**
 * @author py
 */
@AdvancedFeignClient
public interface RemoteSupplierInfoService {

    /**
     * 查询供应商列表
     * @param param
     * @return
     */
    Page<SupplierInfoDto> querySupplierList(SupplierParam param);

    /**
     * 查询供应商详情
     * @param id
     * @return
     */
    SupplierInfoDto querySupplierInfoById(Long id);

    /**
     * 新增供应商
     * @param dto
     * @return
     */
    Long saveSupplierInfo(SupplierInfoDto dto);

    /**
     * 批量新增供应商
     * @param dtoList
     * @return
     */
    int batchSaveSupplierInfo(List<SupplierInfoDto> dtoList);

    /**
     * 编辑供应商
     * @param dto
     * @return
     */
    Boolean editSupplierInfo(SupplierInfoDto dto);

    /**
     * 删除供应商
     * @param supplierId
     * @return
     */
    Boolean delSupplierInfo(Long supplierId);

}
