package cn.com.duiba.supplier.center.api.enums;

/**
 * @program: supplier-center
 * @description: 京东订单状态枚举类 （京东给的枚举无15、20节点状态）
 * @author: Simba
 * @create: 2019-06-20 17:37
 **/
public enum JdOrderStateEnums {

    NEW_ORDER(1, "新单"),

    WAIT_PAY(2, "等待支付"),

    WAIT_PAY_CONFIRM(3, "等待支付确认"),

    DELAY_PAY_CONFIRM(4, "延迟付款确认"),

    PAUSE_ORDER(5, "订单暂停"),

    BOSS_FINAL_REVIEW(6, "店长最终审核"),

    WAIT_PRINT(7, "等待打印"),

    WAIT_OUTBOUND(8, "等待出库"),

    WAIT_BALE(9, "等待打包"),

    WAIT_SEND(10, "等待发货"),

    SELF_LIFTING(11, "自提途中"),

    HOME_DELIVERY(12, "上门提货"),

    SELF_RETURN(13, "自提退货"),

    SELF_CONFIRM(14, "确认自提"),

    WAIT_RECEIVE_CONFIRM(16, "等待确认收货"),

    DELIVERY_RETURN(17, "配送退货"),

    CASH_ON_DELIVERY_CONFIRM(18, "货到付款确认"),

    FINISH(19, "已完成"),

    RECEICER_CONFIRM(21, "收款确认"),

    LOCK(22, "锁定"),

    WAIT_TRIPARTITE_OUTBOUND(29, "等待三方出库"),

    WAIT_TRIPARTITE_DELIVERY(30, "等待三方发货"),

    WAIT_TRIPARTITE_DELIVERY_FINISH(31, "等待三方发货完成"),
    ;

    private int code;
    private String desc;

    JdOrderStateEnums(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

