package cn.com.duiba.supplier.center.api.request.supply;

import cn.com.duiba.supplier.center.api.enums.DuiBaSupplyOrdersPushBizTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 保存推送记录入参
 *
 * @author wgh
 */
@Data
public class SavePushRecordRequest implements Serializable {

    private static final long serialVersionUID = 8049088289876738718L;

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 重试次数
     */
    private Integer retryCount;

    /**
     * 推送参数
     */
    private Map<String, String> params;

    /**
     * 响应参数
     */
    String response;

    /**
     * 业务类型
     */
    DuiBaSupplyOrdersPushBizTypeEnum duiBaSupplyOrdersPushBizTypeEnum;

}
