package cn.com.duiba.supplier.center.api.dto;

import cn.com.duiba.api.bo.order.ObjectExpressDto;

import java.io.Serializable;

/**
 * @author qianjue
 * @date 2018/12/6
 * @description: 供应商发货通知接口
 */
public class OrderSendNotifyMessage implements Serializable {

    private static final long serialVersionUID = -51757803946438790L;
    /**
     * 交易订单号
     */
    private String  orderNum;
    /**
     * 交易子订单号
     */
    private Long ordersItemId;
    /**
     * 交易订单id
     */
    private Long  orderId;
    /**
     * 采购单号
     */
    private String purchaseNum;

    /**
     * 发货状态,True：实物：已发货 其他：发货成功 False:发货失败，取消发货
     */
    private Boolean sendStatus;
    /**
     * 供应商发货信息，用json字符串返回
     */
    private String  supplierInfo;
    /**
     * 非实物订单为发货失败的原因，如果是实物订单为取消订单的原因
     */
    private String  errorMsg;

    /**
     * 物流订单信息，针对实物订单才存在
     */
    private ObjectExpressDto objectExpressDto;

    /**
     * 可以根据type区分消息
     */
    private String type;


    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getPurchaseNum() {
        return purchaseNum;
    }

    public void setPurchaseNum(String purchaseNum) {
        this.purchaseNum = purchaseNum;
    }

    public Boolean getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Boolean sendStatus) {
        this.sendStatus = sendStatus;
    }

    public String getSupplierInfo() {
        return supplierInfo;
    }

    public void setSupplierInfo(String supplierInfo) {
        this.supplierInfo = supplierInfo;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public ObjectExpressDto getObjectExpressDto() {
        return objectExpressDto;
    }

    public void setObjectExpressDto(ObjectExpressDto objectExpressDto) {
        this.objectExpressDto = objectExpressDto;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
