package cn.com.duiba.supplier.center.api.params;

import lombok.Data;

import java.io.Serializable;

/**
 * 蓝海银行核销通知接口参数
 *
 * @author wgh
 */
@Data
public class BlueOceanBankConsumeNoticeParam implements Serializable {

    private static final long serialVersionUID = -859653830239391064L;

    /**
     * 用户ID标识
     */
    private String userSeq;

    /**
     * 第三方订单号
     */
    private String outOrderId;

    /**
     * 抽奖活动上送20211118，异步通知与下单接口请求一致
     */
    private String campaignId;

    /**
     * 奖品兑换时间（兑吧订单下单时间）
     */
    private String exchangeTime;

    /**
     * 奖品ID
     */
    private String rewardRuleId;

    /**
     * 批次号（微信stockId）
     */
    private String batchNumber;

    /**
     * 优惠ID（微信couponId）
     */
    private String couponId;

    /**
     * 核销时间（微信领券时间）
     */
    private String consumeTime;

    /**
     * 核销金额（微信面额，精度Decimal(8,2)）
     */
    private String consumeAmount;

    /**
     * 充值账号（微信立减金为openid，支付宝为手机号/邮箱）兑吧订单rechargeAccount
     */
    private String rechargeAccount;

    /**
     * 交易类型（1-核销）
     */
    private String transType;

    /**
     * 备注（非必填）
     */
    private String remark;

}
