package cn.com.duiba.supplier.center.api.enums;

/**
 * 支持的采购单下单类型
 */
public enum PurchaseTypeEnum {

    OBJECT("实物订单", "object"),

    COUPON("优惠券", "coupon"),

    CRYPTO_CARD("卡密", "cryptoCard"),

    VIRTUAL("虚拟商品", "virtual"),

    PHONEBILL("话费", "phonebill"),

    ;

    private String desc;
    private String itemType;

    PurchaseTypeEnum(String desc, String itemType) {
        this.desc = desc;
        this.itemType = itemType;
    }

    public String getDesc() {
        return desc;
    }

    public String getItemType() {
        return itemType;
    }

    public static String getItemType(String name) {
        return valueOf(name).itemType;
    }

    public static PurchaseTypeEnum ofType(String itemType) {
        if (itemType == null) {
            return null;
        }
        for (PurchaseTypeEnum type : values()) {
            if (type.getItemType().equals(itemType)) {
                return type;
            }
        }
        return null;
    }
}
