package cn.com.duiba.supplier.center.api.params;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author qiurenjie
 * @date 2023-03-20 13:41
 */
public class BlueOceanBankNotifyOrderParam {

    /**
     * 用户ID标识
     */
    private String userSeq;

    /**
     * 第三方订单号
     */
    private String outOrderId;

    /**
     * 抽奖活动上送20211118，异步通知与下单接口请求一致
     */
    private String campaignId;

    /**
     * 客户中奖时间
     */
    private String transTime;

    /**
     * 奖品ID
     */
    private String rewardRuleId;

    /**
     * 领奖状态
     * 0=成功
     * 1=失败
     */
    private String receiveState;

    /**
     * 市场价格
     * 非必填
     */
    private BigDecimal markerpRice;

    /**
     * 采购价格
     * 非必填
     */
    private BigDecimal purchasepRice;

    /**
     * 奖品有效期开始时间
     * 非必填
     */
    private String beginTime;

    /**
     * 奖品有效期结束时间
     * 非必填
     */
    private String endTime;

    /**
     * 备注
     * 非必填
     */
    private String remark;

    /**
     * 活动id：2021118会员日时上送
     * 非必填
     */
    private String awardId;

    /**
     * 卡券列表数组
     */
    private List<CardVO> cardList;

    public static class CardVO {

        /**
         * 卡号
         */
        private String virtualCode;

        /**
         * 卡密
         */
        private String virtualPwd;

        /**
         * 有效期开始时间
         */
        private String beginTime;

        /**
         * 有效期结束时间
         */
        private String endTime;

        public String getVirtualCode() {
            return virtualCode;
        }

        public void setVirtualCode(String virtualCode) {
            this.virtualCode = virtualCode;
        }

        public String getVirtualPwd() {
            return virtualPwd;
        }

        public void setVirtualPwd(String virtualPwd) {
            this.virtualPwd = virtualPwd;
        }

        public String getBeginTime() {
            return beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getEndTime() {
            return endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }

    public String getUserSeq() {
        return userSeq;
    }

    public void setUserSeq(String userSeq) {
        this.userSeq = userSeq;
    }

    public String getOutOrderId() {
        return outOrderId;
    }

    public void setOutOrderId(String outOrderId) {
        this.outOrderId = outOrderId;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public String getTransTime() {
        return transTime;
    }

    public void setTransTime(String transTime) {
        this.transTime = transTime;
    }

    public String getRewardRuleId() {
        return rewardRuleId;
    }

    public void setRewardRuleId(String rewardRuleId) {
        this.rewardRuleId = rewardRuleId;
    }

    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }

    public BigDecimal getMarkerpRice() {
        return markerpRice;
    }

    public void setMarkerpRice(BigDecimal markerpRice) {
        this.markerpRice = markerpRice;
    }

    public BigDecimal getPurchasepRice() {
        return purchasepRice;
    }

    public void setPurchasepRice(BigDecimal purchasepRice) {
        this.purchasepRice = purchasepRice;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAwardId() {
        return awardId;
    }

    public void setAwardId(String awardId) {
        this.awardId = awardId;
    }

    public List<CardVO> getCardList() {
        return cardList;
    }

    public void setCardList(List<CardVO> cardList) {
        this.cardList = cardList;
    }
}
