package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.LogisticsDTO;
import cn.com.duiba.supplier.center.api.params.OrderLogisticsParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteOrderLogisticsService {

    /**
     * 查询订单
     * @param param 查询参数
     * @return 订单信息
     */
    List<LogisticsDTO> selectOrder(OrderLogisticsParam param);


    /**
     * 根据ID更新订单状态
     * @param entity 订单信息
     * @return 结果
     */
    int updateById(LogisticsDTO entity);


    /**
     * 插入数据
     */
    Long insert(LogisticsDTO entity);

    /**
     * 根据物流单号更新物流信息
     * @param logisticsInfo 物流信息
     * @param logisticsNum 物流单号
     * @return 结果
     */
    int updateLogisticsInfoByLogisticsNum(String logisticsInfo, String logisticsNum);

}
