package cn.com.duiba.supplier.center.api.response;


import cn.com.duiba.supplier.center.api.enums.ErrorCodeEnums;
import cn.com.duiba.supplier.center.api.enums.OrderReturnStatusEnum;

import java.io.Serializable;

/**
 * Created by hww on 2018/11/28 12:03 PM.
 */
public class ConfirmOrderResponse implements Serializable {
    private static final long serialVersionUID = -2489614306940166943L;

    private int status;

    private String resultCode;

    private String resultMessage;

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMessage() {
        return resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public static ConfirmOrderResponse success() {
        ConfirmOrderResponse response = new ConfirmOrderResponse();
        response.setStatus(OrderReturnStatusEnum.SUCCESS.getCode());
        response.setResultCode(ErrorCodeEnums.RC_00001.getCode());
        response.setResultMessage(ErrorCodeEnums.RC_00001.getMessage());
        return response;
    }

    public static ConfirmOrderResponse fail() {
        return fail(ErrorCodeEnums.RC_00002);
    }

    public static ConfirmOrderResponse fail(ErrorCodeEnums code) {
        return fail(code.getCode(), code.getMessage());
    }

    public static ConfirmOrderResponse fail(String code, String message) {
        ConfirmOrderResponse response = new ConfirmOrderResponse();
        response.setStatus(OrderReturnStatusEnum.FAIL.getCode());
        response.setResultCode(code);
        response.setResultMessage(message);
        return response;
    }

    /**
     * 卡单，需人工处理
     * @param code
     * @return
     */
    public static ConfirmOrderResponse manualHandle(ErrorCodeEnums code) {
        ConfirmOrderResponse response = new ConfirmOrderResponse();
        response.setStatus(OrderReturnStatusEnum.MANUAL_HANDLE.getCode());
        response.setResultCode(code.getCode());
        response.setResultMessage(code.getMessage());
        return response;
    }

}
