/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.supplier.center.api.enums;

import cn.com.duiba.supplier.center.api.dto.SupplierDto;
import cn.com.duiba.supplier.center.api.remoteservice.supplier.RemoteSupplierService;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SupplyTypeEnumUtil
implements CommandLineRunner {
    public static final Long DUIBA_LIVE_SUPPLIER_PLATFORM = 24L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SupplyTypeEnumUtil.class);
    @Autowired
    private RemoteSupplierService remoteSupplierService;
    private static RemoteSupplierService remoteSupplierServicestatic;
    private static final Map<String, SupplierDto> supplierInfoMap;
    private static final Cache<String, SupplierDto> SUPPLIER_INFO_CACHE;

    public void run(String ... args) throws Exception {
        remoteSupplierServicestatic = this.remoteSupplierService;
        List<SupplierDto> allSupplierInfoDatas = this.remoteSupplierService.getAllDatas();
        if (CollectionUtils.isNotEmpty(allSupplierInfoDatas)) {
            for (SupplierDto allSupplierInfoData : allSupplierInfoDatas) {
                supplierInfoMap.put(allSupplierInfoData.getId().toString(), allSupplierInfoData);
            }
        }
        LOGGER.info("supplierInfoMap \u521d\u59cb\u5316\u6210\u529f {}", (Object)JSON.toJSONString(supplierInfoMap));
    }

    public static SupplierDto getSupplierInfoById(String supplierId) {
        SupplierDto present = (SupplierDto)SUPPLIER_INFO_CACHE.getIfPresent((Object)supplierId);
        if (present == null) {
            List<SupplierDto> allSupplierInfoDatas = remoteSupplierServicestatic.getAllDatas();
            if (CollectionUtils.isNotEmpty(allSupplierInfoDatas)) {
                for (SupplierDto allSupplierInfoData : allSupplierInfoDatas) {
                    supplierInfoMap.put(allSupplierInfoData.getId().toString(), allSupplierInfoData);
                    SUPPLIER_INFO_CACHE.put((Object)allSupplierInfoData.getId().toString(), (Object)allSupplierInfoData);
                }
            }
            LOGGER.info("\u8fc7\u671f\u540e\u91cd\u65b0\u52a0\u8f7d\uff0csupplierInfoMap = {}", (Object)JSON.toJSONString(supplierInfoMap));
            return (SupplierDto)SUPPLIER_INFO_CACHE.getIfPresent((Object)supplierId);
        }
        return present;
    }

    public static String getSupplierNameInfoById(String supplierId) {
        Optional<SupplierDto> supplierDto = Optional.ofNullable(SupplyTypeEnumUtil.getSupplierInfoById(supplierId));
        return supplierDto.isPresent() ? supplierDto.get().getCompany() : null;
    }

    public static void invalidate(String supplierId) {
        SUPPLIER_INFO_CACHE.invalidate((Object)supplierId);
    }

    static {
        supplierInfoMap = new ConcurrentHashMap<String, SupplierDto>();
        SUPPLIER_INFO_CACHE = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(100L).build();
    }
}

