package cn.com.duiba.supplier.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 三方信息
 */
@Data
public class ThirdCouponDTO implements Serializable {


    private static final long serialVersionUID = -4958109923959496002L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 兑吧appId
     */
    private Long appId;

    /**
     * 活动ID
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 兑吧订单ID
     */
    private String orderNum;

    /**
     * 卡券ID
     */
    private String couponId;

    /**
     * 银行流水号
     */
    private String bankOrderNo;

    /**
     * 交易订单号
     */
    private String tradeNo;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 订单状态
     * @see cn.com.duiba.supplier.center.api.enums.ThirdCouponStatusEnum
     */
    private String orderStatus;

    /**
     * 领取时间
     */
    private Date drawTime;

    /**
     * 使用开始时间
     */
    private Date useStartTime;

    /**
     * 使用结束时间
     */
    private Date useEndTime;

    /**
     * 核销时间
     */
    private Date costTime;

    /**
     * 卡券信息
     */
    private String couponInfo;

    /**
     * 奖品发放信息
     */
    private String prizeInfo;

    /**
     * 核销记录信息
     */
    private String costInfo;

    /**
     * 奖品类型
     * @see cn.com.duiba.supplier.center.api.enums.ThirdCouponActivityTypeEnum
     */
    private Integer prizeType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


}
