package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.order.JdAfterSaleDto;
import cn.com.duiba.supplier.center.api.dto.order.JdOrderDetailDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAbnormalOrderService {
    /**
     * 查询京东订单详情
     * @param supplyOrderNum
     * @return
     */
    List<JdOrderDetailDto> queryJdPayOrder(String supplyOrderNum) throws BizException;

    /**
     * 京东物流信息拉取
     * @param supplyOrderNums
     * @return
     * @throws BizException
     */
    Boolean pullJdExpressMsg(String supplyOrderNums) throws BizException;

    /**
     * 查询京东订单售后状态
     * @param supplyOrderNums
     * @throws Exception
     */
    List<JdAfterSaleDto> queryJdAfterSale(String supplyOrderNums) throws BizException;
}
